/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.structure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;
import net.jalbum.ObjectException;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.io.VirtualDirectory;
import se.datadosen.jalbum.structure.Support;
import se.datadosen.jalbum.structure.Transformer;
import se.datadosen.util.IO;

public class AlphabeticalTransformer
implements Transformer<AlphabeticalTransformer> {
    private String groupBy = "name";
    private transient Function<AlbumObject, String> func;

    @Override
    public AlbumObject transform(AlbumObject tree, VirtualFolder newRoot) {
        try {
            Method method = AlbumObject.class.getMethod(AlphabeticalTransformer.getGetterMethodName(this.groupBy), new Class[0]);
            this.func = ao -> {
                try {
                    return (String)method.invoke(ao, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    throw new ObjectException(ao, (Throwable)ex);
                }
            };
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        Support.toStream(tree).filter(ao -> this.safeString((AlbumObject)ao, this.func).length() > 0).sorted((o1, o2) -> this.safeString((AlbumObject)o1, this.func).compareToIgnoreCase(this.safeString((AlbumObject)o2, this.func))).forEach(ao -> this.add((AlbumObject)ao, newRoot));
        return newRoot;
    }

    private void add(AlbumObject ao, VirtualFolder parent) {
        String initial = Character.toString(this.safeString(ao, this.func).charAt(0)).toUpperCase();
        VirtualFolder folder = (VirtualFolder)parent.getChild(initial);
        if (folder == null) {
            folder = new VirtualFolder(new VirtualDirectory(parent.getFile(), initial), parent, parent.getFactory());
            parent.add(folder);
        }
        folder.addFileOf(ao);
    }

    private String safeString(AlbumObject ao, Function<AlbumObject, String> func) {
        String s = func.apply(ao);
        s = s.trim();
        s = IO.webSafe(s);
        return s;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    private static String getGetterMethodName(String attributeName) {
        return "get" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.groupBy);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlphabeticalTransformer other = (AlphabeticalTransformer)obj;
        return Objects.equals(this.groupBy, other.groupBy);
    }

    @Override
    public AlphabeticalTransformer copy() {
        return new AlphabeticalTransformer();
    }
}

