/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.scaling;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.TreeMap;
import se.datadosen.jalbum.scaling.BetterMediumScaler;
import se.datadosen.jalbum.scaling.CustomScaler;
import se.datadosen.jalbum.scaling.FastScaler;
import se.datadosen.jalbum.scaling.HardwareSmoothScaler;
import se.datadosen.jalbum.scaling.SmoothScaler;

public abstract class ImageScaler {
    private static TreeMap scalers = new TreeMap();

    public static ImageScaler getScaler(String name) {
        return ImageScaler.getScaler(name, true);
    }

    public static ImageScaler getScaler(String name, boolean hardwareScaling) {
        return ImageScaler.getScaler(name, hardwareScaling, CustomScaler.Type.BLACKMAN_SINC);
    }

    public static ImageScaler getScaler(String name, boolean hardwareScaling, CustomScaler.Type type) {
        if ("ScaleFast".equals(name)) {
            return new FastScaler();
        }
        if ("ScaleSmooth".equals(name) || "ScaleCustom".equals(name)) {
            if (type == CustomScaler.Type.STANDARD) {
                return hardwareScaling ? new HardwareSmoothScaler() : new SmoothScaler();
            }
            return new CustomScaler(type);
        }
        if ("ScaleMedium".equals(name)) {
            return hardwareScaling ? new BetterMediumScaler() : new CustomScaler();
        }
        return (ImageScaler)scalers.get(name);
    }

    public static String[] getScalerNames() {
        LinkedList<String> names = new LinkedList<String>();
        names.add("ScaleFast");
        names.add("ScaleMedium");
        names.add("ScaleSmooth");
        names.addAll(scalers.keySet());
        return names.toArray(new String[scalers.size()]);
    }

    BufferedImage createBufferedImage(Image src, int w, int h) {
        int type = 2;
        if (src instanceof BufferedImage) {
            type = ((BufferedImage)src).getType();
        }
        BufferedImage buf = new BufferedImage(w, h, type);
        Graphics g = buf.getGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        src.flush();
        return buf;
    }

    public static void registerScaler(String name, ImageScaler scaler) {
        scalers.put(name, scaler);
    }

    public abstract BufferedImage scale(Image var1, int var2, int var3);
}

