/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Stream;
import se.datadosen.io.CachedFile;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.io.FileTreeCollection;
import se.datadosen.jalbum.io.Walker;

public class FileTreeProcessor
implements AutoCloseable {
    private final Stream<File> stream;
    private ForkJoinPool thePool;

    public FileTreeProcessor(FileTreeCollection collection) {
        this(collection, 8);
    }

    public FileTreeProcessor(FileTreeCollection collection, int nThreads) {
        this.stream = collection.stream();
        this.init(nThreads);
    }

    public FileTreeProcessor(File[] files, FileFilter filter) {
        this.stream = Walker.walk(Stream.of(files), t -> t.isDirectory() ? Stream.of(CachedFile.listFiles(t, filter)) : Stream.empty());
        this.init(8);
    }

    private void init(int nThreads) {
        this.thePool = new ForkJoinPool(nThreads, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }

    @Override
    public void close() {
        this.shutdownNow();
    }

    public void shutdownNow() {
        this.thePool.shutdownNow();
    }

    public boolean isShutdown() {
        return this.thePool.isShutdown();
    }

    public <R> R process(Function<Stream<File>, R> func) throws IOException, OperationAbortedException {
        try {
            Future task = this.thePool.submit(() -> func.apply((Stream)this.stream.parallel()));
            this.thePool.shutdown();
            return (R)((ForkJoinTask)task).get();
        }
        catch (InterruptedException ex) {
            System.out.println("Interrupted");
            throw new OperationAbortedException();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof UncheckedIOException) {
                throw (IOException)ex.getCause().getCause();
            }
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    public long getTotalByteSize() throws IOException, OperationAbortedException {
        return this.process(str -> str.filter(f -> f.isFile()).mapToLong(File::length).sum());
    }
}

