/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import se.datadosen.io.CachedFile;

public class FileTreeCollection
extends AbstractCollection<File> {
    static AtomicLong splitCount = new AtomicLong(0L);
    private File dir;
    private Collection<File> objects;
    private FileFilter fileFilter;
    private Set<File> visited;

    public FileTreeCollection(File dir) {
        this.dir = dir;
    }

    public FileTreeCollection(File dir, FileFilter filter) {
        this.dir = dir;
        this.fileFilter = filter;
    }

    public FileTreeCollection(Collection<File> objects) {
        this.objects = objects;
    }

    public FileTreeCollection(File[] objects, FileFilter filter) {
        this.objects = Arrays.asList(objects);
        this.fileFilter = filter;
    }

    public FileTreeCollection(File[] objects) {
        this.objects = Arrays.asList(objects);
    }

    public FileTreeCollection(Collection<File> objects, FileFilter filter) {
        this.objects = objects;
        this.fileFilter = filter;
    }

    public static FileTreeCollection of(Collection<File> objects) {
        return new FileTreeCollection(objects);
    }

    private Collection<File> source() {
        this.visited = new HashSet<File>();
        if (this.dir != null) {
            this.visited.add(this.dir);
        }
        return this.dir != null ? Arrays.asList(CachedFile.listFiles(this.dir, this.fileFilter)) : this.objects;
    }

    @Override
    public Spliterator<File> spliterator() {
        try {
            return new TreeSpliterator(this.source().spliterator());
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("Null getChildren() for " + this.dir.getAbsolutePath());
        }
    }

    @Override
    public Iterator<File> iterator() {
        return new TreeIterator(this.source().iterator());
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<File> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    private class TreeSpliterator
    implements Spliterator<File>,
    Consumer<File> {
        private Spliterator<File> it;
        private final Deque<Spliterator<File>> stack = new ArrayDeque<Spliterator<File>>();
        private File currentFile;
        private File dir;

        public TreeSpliterator(Spliterator<File> it) {
            this.it = it;
        }

        private TreeSpliterator(Spliterator<File> it, File dir) {
            this.it = it;
            this.dir = dir;
        }

        @Override
        public boolean tryAdvance(Consumer<? super File> action) {
            boolean ret = this.it.tryAdvance(this);
            if (ret) {
                action.accept(this.currentFile);
                if (this.currentFile.isDirectory() && !FileTreeCollection.this.visited.contains(this.currentFile)) {
                    FileTreeCollection.this.visited.add(this.currentFile);
                    CachedFile[] contents = CachedFile.listFiles(this.currentFile, FileTreeCollection.this.fileFilter);
                    if (contents == null) {
                        throw new UncheckedIOException(new IOException("Can't access " + String.valueOf(this.currentFile)));
                    }
                    List<CachedFile> children = Arrays.asList(contents);
                    this.stack.push(this.it);
                    this.it = new TreeSpliterator(children.spliterator(), this.dir);
                }
            } else if (!this.stack.isEmpty()) {
                this.it = this.stack.pop();
                return this.tryAdvance(action);
            }
            return ret;
        }

        @Override
        public Spliterator<File> trySplit() {
            Spliterator<File> sub = this.it.trySplit();
            if (sub != null) {
                return new TreeSpliterator(sub, this.dir);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1280;
        }

        @Override
        public void accept(File f) {
            this.currentFile = f;
        }

        public String toString() {
            return "Spliterator for " + String.valueOf(this.dir);
        }
    }

    private class TreeIterator
    implements Iterator<File> {
        private Iterator<File> it;
        private final Deque<Iterator<File>> stack = new ArrayDeque<Iterator<File>>();

        public TreeIterator(Iterator<File> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.it.hasNext()) {
                return true;
            }
            for (Iterator<File> it2 : this.stack) {
                if (!it2.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public File next() {
            if (this.it.hasNext()) {
                File next = this.it.next();
                if (next.isDirectory() && !FileTreeCollection.this.visited.contains(next)) {
                    FileTreeCollection.this.visited.add(next);
                    List<CachedFile> children = Arrays.asList(CachedFile.listFiles(next, FileTreeCollection.this.fileFilter));
                    this.stack.push(this.it);
                    this.it = children.iterator();
                }
                return next;
            }
            if (!this.stack.isEmpty()) {
                this.it = this.stack.pop();
                return this.next();
            }
            throw new NoSuchElementException();
        }
    }
}

