/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import se.datadosen.jalbum.AST;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ast.ASTNode;
import se.datadosen.jalbum.ast.CaseNode;
import se.datadosen.jalbum.ast.DefaultNode;
import se.datadosen.jalbum.ast.ElementNode;
import se.datadosen.jalbum.ast.TextNode;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;

public class SwitchNode
extends ElementNode {
    Map<String, CaseNode> cases = new HashMap<String, CaseNode>();
    private DefaultNode defaultNode;

    public SwitchNode(Element elem, AST ast) throws ElementException {
        super(elem);
        this.setMembers(ast.buildTree(elem.getContent()).getMembers());
        if (elem.getAttribute("test") == null) {
            throw new ElementException(Msg.get("scripting.missingTestAttibuteForJaSwitchElement"), elem.getContent());
        }
        for (ASTNode node : this.getMembers()) {
            if (node instanceof CaseNode) {
                CaseNode cn = (CaseNode)node;
                this.cases.put(cn.getValue(), cn);
                if (this.defaultNode == null) continue;
                throw new ElementException(Msg.get("scripting.JaDefaultNotLastInJaSwitch"), elem.getContent());
            }
            if (node instanceof DefaultNode) {
                this.defaultNode = (DefaultNode)node;
                continue;
            }
            if (node instanceof TextNode) continue;
            throw new ElementException(Msg.get("scripting.invalidElementForJaSwitch") + ": " + String.valueOf(node.getSection()), elem.getContent());
        }
    }

    @Override
    protected void doEval(ASTEvaluator ev, StringBuilder out) throws ScriptException, ElementException {
        ElementNode.Attributes a = this.getAttributes(ev);
        String test = a.get("test");
        CaseNode found = this.cases.get(test);
        if (found != null) {
            found.eval(ev, out);
        } else if (this.defaultNode != null) {
            this.defaultNode.eval(ev, out);
        }
    }
}

