/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import net.jalbum.OutputFormat;
import net.jalbum.Rendition;
import se.datadosen.jalbum.AST;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.ImageRenderer;
import se.datadosen.jalbum.ast.ElementNode;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;

public class PictureNode
extends ElementNode {
    public PictureNode(Element elem, AST ast) throws ElementException {
        super(elem);
        this.setMembers(ast.buildTree(elem.getContent()).getMembers());
    }

    private void addSourceElement(List<Rendition> renditions, String typicalPath, StringBuilder out) {
        if (!renditions.isEmpty()) {
            out.append("<source type=\"");
            out.append(renditions.get(0).getFormat().getMimeType());
            out.append("\" srcset=\"");
            out.append(ImageRenderer.buildSrcset(renditions, typicalPath));
            out.append("\"/>");
        }
    }

    @Override
    protected void doEval(ASTEvaluator ev, StringBuilder out) throws ScriptException, ElementException {
        ElementNode.Attributes a = this.getAttributes(ev);
        boolean always = a.getOrDefault("always", false);
        boolean isThumbs = a.getOrDefault("thumbs", this.element.getContent().indexOf("${thumbPath}") != -1);
        AlbumObject ao = (AlbumObject)ev.getVar("currentObject");
        ImageRenderer renderer = ao.getRenderer();
        if (!always) {
            Object renditions;
            Object object = renditions = isThumbs ? renderer.getThumbRenditions() : renderer.getCloseupRenditions();
            if (renditions.size() < 2) {
                super.doEval(ev, out);
                return;
            }
        }
        out.append("<picture");
        for (Map.Entry entry : this.element.getAttributes().entrySet()) {
            if ("always".equals(entry.getKey()) || "thumbs".equals(entry.getKey())) continue;
            out.append(" ");
            out.append((String)entry.getKey());
            out.append("=\"");
            out.append((String)entry.getValue());
            out.append("\"");
        }
        out.append(">");
        String typicalPath = isThumbs ? (String)ev.getVar("thumbPath") : (String)ev.getVar("imagePath");
        for (OutputFormat format : OutputFormat.values()) {
            List<Rendition> renditions = isThumbs ? renderer.getThumbRenditions(format) : renderer.getCloseupRenditions(format);
            this.addSourceElement(renditions, typicalPath, out);
        }
        super.doEval(ev, out);
        out.append("</picture>");
    }
}

