/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import javax.script.ScriptException;
import se.datadosen.jalbum.AST;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.ast.ColIteratorNode;
import se.datadosen.jalbum.ast.ElementNode;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Scope;

public class IteratorNode
extends ElementNode {
    private final Supplier<AlbumObject[]> objectsSupplier;

    public IteratorNode(Element elem, AST ast, Supplier<AlbumObject[]> objectsSupplier) throws ElementException {
        super(elem);
        this.objectsSupplier = objectsSupplier;
        this.setMembers(ast.buildTree(elem.getContent()).getMembers());
    }

    @Override
    protected void doEval(ASTEvaluator ev, StringBuilder out) throws ScriptException, ElementException {
        AlbumObject[] localObjects = this.objectsSupplier.get();
        Scope scope = ev.getScope();
        int indexNum = scope.getOrDefault("indexNum", 1) - 1;
        AlbumBean engine = ev.getAlbumEngine();
        int imagesPerIndex = ColIteratorNode.getImagesPerIndex(engine);
        int imageNum = indexNum * imagesPerIndex;
        ElementNode.Attributes a = this.getAttributes(ev);
        String include = a.getOrDefault("category", a.get("include"));
        String exclude = a.get("exclude");
        boolean dirs = include == null && a.containsKey("dirs");
        boolean nodirs = exclude == null && a.containsKey("nodirs");
        Set<Category> includes = include != null ? IteratorNode.setOf(include) : null;
        Set<Category> excludes = exclude != null ? IteratorNode.setOf(exclude) : null;
        localObjects = (AlbumObject[])Arrays.stream(localObjects).filter(ao -> !dirs || ao.isFolder()).filter(ao -> !nodirs || !ao.isFolder()).filter(ao -> includes == null || includes.contains((Object)ao.getCategory())).filter(ao -> excludes == null || !excludes.contains((Object)ao.getCategory())).toArray(AlbumObject[]::new);
        File[] files = (File[])Arrays.stream(localObjects).map(ao -> ao.getFile()).toArray(File[]::new);
        if (a.containsKey("start") || !scope.containsKey("currentRows")) {
            int start;
            boolean relative = false;
            String s = a.getOrDefault("start", "0");
            if (s.startsWith("+")) {
                relative = true;
                start = Integer.parseInt(s.substring(1));
            } else {
                start = Integer.parseInt(s);
            }
            if (start < 0) {
                relative = true;
            }
            int count = a.getOrDefault("count", Integer.MAX_VALUE);
            int step = a.getOrDefault("step", 1);
            if (relative) {
                if (!scope.containsKey("imageNum")) {
                    throw new ElementException("Relative indexing in ja:fileiterator not allowed in this scope", this.element.getContent());
                }
                int current = (Integer)scope.get("imageNum") - 1;
                start += current;
            }
            int oldStart = start;
            if (start < 0) {
                start = 0;
            }
            count -= Math.abs(start - oldStart);
            for (int i = start; i >= 0 && i < localObjects.length && count-- > 0; i += step) {
                this.handleIteration(i, localObjects, files, ev, out);
            }
        } else {
            int currentRows = (Integer)scope.get("currentRows");
            for (int i = imageNum; i < localObjects.length && i - imageNum < currentRows * engine.getCols(); ++i) {
                this.handleIteration(i, localObjects, files, ev, out);
            }
        }
    }

    private void handleIteration(int i, AlbumObject[] localObjects, File[] files, ASTEvaluator ev, StringBuilder out) throws ElementException, ScriptException {
        Scope locals = localObjects[i].getVars();
        Scope fix = new Scope(locals).name("Fix");
        fix.put("imageNum", (Object)(i + 1));
        fix.put("files", (Object)files);
        ev.enterScope(locals);
        ev.enterScope(fix);
        super.doEval(ev, out);
        ev.exitScope(fix);
        ev.exitScope(locals);
    }
}

