/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import java.io.File;
import java.io.IOException;
import javax.script.ScriptException;
import se.datadosen.jalbum.AST;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ast.ElementNode;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Scope;

public class IncludeNode
extends ElementNode {
    private boolean included;
    private AST ast;

    public IncludeNode(Element elem, AST ast) throws ElementException {
        super(elem);
        this.ast = ast;
    }

    @Override
    protected void doEval(ASTEvaluator ev, StringBuilder out) throws ScriptException, ElementException {
        ElementNode.Attributes a = this.getAttributes(ev);
        String page = a.get("page");
        if (page == null) {
            throw new ElementException(Msg.get("scripting.missingPageAttributeForJaIncludeElementError"), this.element.getContent());
        }
        File f = new File(page);
        boolean once = a.containsKey("once");
        boolean root = a.containsKey("root");
        if (once && this.included) {
            return;
        }
        this.included = true;
        if (!f.isAbsolute()) {
            File curdir;
            if (root) {
                curdir = (File)ev.getVar("rootImageDirectory");
                if (curdir != null) {
                    f = new File(curdir, page);
                }
            } else {
                curdir = (File)ev.getVar("imageDirectory");
                if (curdir != null) {
                    f = new File(curdir, page);
                }
                if (!f.exists() && (curdir = (File)ev.getVar("skinDirectory")) != null && !(f = new File(curdir, page)).exists()) {
                    curdir = new File(Config.getConfig().progDir, "includes");
                    f = new File(curdir, page);
                }
            }
        }
        Scope includeScope = null;
        try {
            if (f.exists()) {
                includeScope = new Scope(this.element.getAttributes()).name("Include");
                includeScope.putAll(this.element.getAttributes());
                ev.enterScope(includeScope);
                AST inc = ev.getAlbumEngine().getASTCache().get(f);
                this.setMembers(inc.getRootNode().getMembers());
            } else {
                this.setMembers(this.ast.buildTree(this.element.getContent()).getMembers());
            }
        }
        catch (IOException ex) {
            this.setMembers(this.ast.buildTree(this.element.getContent()).getMembers());
        }
        super.doEval(ev, out);
        if (includeScope != null) {
            ev.exitScope(includeScope);
        }
    }
}

