/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.ast;

import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptException;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.ast.ASTNode;
import se.datadosen.jalbum.ast.TextNode;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Section;

public class GroupNode
extends ASTNode {
    private List<ASTNode> members;

    public GroupNode(Section section) {
        super(section);
    }

    public GroupNode(int beginIndex) {
        super(beginIndex);
    }

    public GroupNode() {
        super(-1);
    }

    public GroupNode(List<ASTNode> children) {
        super(-1);
        this.members = children;
    }

    public List<ASTNode> getMembers() {
        return this.members;
    }

    public int getMemberCount() {
        return this.members != null ? this.members.size() : 0;
    }

    protected void setMembers(List<ASTNode> members) {
        this.members = members;
    }

    public boolean addTextNode(Section section) {
        if (section.length() > 0) {
            this.add(new TextNode(section));
            return true;
        }
        return false;
    }

    public boolean add(ASTNode member) {
        if (member instanceof TextNode && ((TextNode)member).isEmpty()) {
            return false;
        }
        if (this.members == null) {
            this.members = new ArrayList<ASTNode>();
        }
        this.members.add(member);
        return true;
    }

    @Override
    protected void doEval(ASTEvaluator ev, StringBuilder out) throws ScriptException, ElementException {
        if (this.members != null) {
            for (ASTNode node : this.members) {
                node.eval(ev, out);
            }
        }
    }
}

