/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import net.jalbum.resty.web.XMLResource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.Widget;

public class Widgets {
    public static boolean hasWidgets(AlbumObject rootFolder, AlbumBean engine) {
        AlbumObjectProperties props = rootFolder.getProperties();
        if (!SignInManager.getInstance().isSignedIn() || !engine.isWidgetInjection()) {
            return false;
        }
        List<Widget> widgets = (List<Widget>)props.get("widgets");
        if (widgets == null) {
            try {
                widgets = Widgets.getRemoteWidgets(rootFolder);
                props.put("widgets", widgets);
                props.save(true);
            }
            catch (IOException ex) {
                return true;
            }
        }
        for (Widget widget : widgets) {
            if (!Boolean.TRUE.equals(widget.getActive())) continue;
            return true;
        }
        return false;
    }

    public static List<Widget> getRemoteWidgets(AlbumObject rootFolder) throws IOException {
        String errorCode;
        AlbumObjectProperties props = null;
        if (rootFolder != null) {
            props = rootFolder.getProperties();
        }
        RobustResty r = new RobustResty();
        HashMap<String, String> data = new HashMap<String, String>();
        SignInManager mgr = SignInManager.getInstance();
        if (mgr.isSignedIn()) {
            data.put("cid", AccountManager.getCid(mgr.getUserName(), mgr.getPassword()));
        }
        if (props != null && props.containsKey("albumURL")) {
            data.put("albumUrl", Notifier.urlEncode((String)props.get("albumURL")));
        }
        data.put("lang", Config.getConfig().getInterpretedLanguage());
        XMLResource xml = r.xml(JAlbumSite.getInstance().getWidgetsAPIUrl(), (AbstractContent)RobustResty.form(data));
        try {
            errorCode = (String)xml.get("/reply/errorCode", String.class);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (errorCode.length() > 0) {
            throw new IOException("Caught exception in reply from Widget API: " + errorCode);
        }
        try {
            NodeList nodes = (NodeList)xml.get("/reply/widgets/widget", NodeList.class);
            return Widgets.parseWidgetXML(nodes);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    static List<Widget> parseWidgetXML(NodeList nodes) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            String sActive = (String)xpath.evaluate("@active", n, XPathConstants.STRING);
            Boolean active = sActive.length() != 0 ? Boolean.valueOf(sActive) : null;
            Widget w = new Widget((String)xpath.evaluate("@id", n, XPathConstants.STRING), (String)xpath.evaluate("name", n, XPathConstants.STRING), (String)xpath.evaluate("description", n, XPathConstants.STRING), (String)xpath.evaluate("icon", n, XPathConstants.STRING), active);
            widgets.add(w);
        }
        return widgets;
    }
}

