/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import se.datadosen.util.IO;

public class WebLocation {
    private static final String USER_AGENT = "curl/7.51.0";
    private URI uri;
    private boolean resolved;
    private URL imageUrl;
    private String title;
    private String description;
    private boolean jsonAlbum;

    public WebLocation(URL url) {
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public WebLocation(URI uri) {
        this.uri = uri;
    }

    public WebLocation(String uri) throws IOException, URISyntaxException {
        this(new URI(uri));
    }

    public URI assertResolved() throws IOException {
        if (!this.resolved && this.uri.isAbsolute()) {
            this.uri = WebLocation.toURI(WebLocation.resolveRedirectedURL(this.uri.toURL()));
            this.resolved = true;
        }
        return this.uri;
    }

    private static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static URL toURL(URI uri) {
        try {
            return uri != null && uri.isAbsolute() ? uri.toURL() : null;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public WebLocation(File webLocFile) throws IOException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(false);
            docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            org.w3c.dom.Document doc = docBuilder.parse(webLocFile);
            doc.getDocumentElement().normalize();
            NodeList keys = doc.getElementsByTagName("key");
            for (int i = 0; i < keys.getLength(); ++i) {
                Node value;
                Node key = keys.item(i);
                if (key.getTextContent().equals("URL")) {
                    for (value = key.getNextSibling(); value != null && value.getNodeType() != 1; value = value.getNextSibling()) {
                    }
                    this.uri = new URI(value.getTextContent());
                }
                if (!key.getTextContent().equals("jsonAlbum")) continue;
                for (value = key.getNextSibling(); value != null && value.getNodeType() != 1; value = value.getNextSibling()) {
                }
                this.jsonAlbum = "true".equals(value.getTextContent());
            }
            if (this.uri == null) {
                throw new IOException("Missing URL value in " + String.valueOf(webLocFile));
            }
        }
        catch (URISyntaxException | ParserConfigurationException | SAXException ex) {
            throw new IOException(ex);
        }
    }

    @Deprecated
    public URL getUrl() throws MalformedURLException {
        return this.uri != null ? this.uri.toURL() : null;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
        this.resolved = false;
    }

    private org.w3c.dom.Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        org.w3c.dom.Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("plist");
        rootElement.setAttribute("version", "1.0");
        doc.appendChild(rootElement);
        Element dict = doc.createElement("dict");
        rootElement.appendChild(dict);
        Element key = doc.createElement("key");
        key.appendChild(doc.createTextNode("URL"));
        dict.appendChild(key);
        Element string = doc.createElement("string");
        string.appendChild(doc.createTextNode(this.uri.toASCIIString()));
        dict.appendChild(string);
        if (this.uri.isAbsolute()) {
            try {
                URI jsonURI = this.uri.resolve("data1.json");
                IO.readTextUrl(jsonURI.toURL());
                this.jsonAlbum = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.jsonAlbum) {
            key = doc.createElement("key");
            key.appendChild(doc.createTextNode("jsonAlbum"));
            dict.appendChild(key);
            string = doc.createElement("string");
            string.appendChild(doc.createTextNode("true"));
            dict.appendChild(string);
        }
        return doc;
    }

    private void writeToStreamResult(org.w3c.dom.Document doc, StreamResult result) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "-//Apple//DTD PLIST 1.0//EN");
            transformer.setOutputProperty("doctype-system", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
        }
        catch (TransformerException pce) {
            throw new RuntimeException(pce);
        }
    }

    public String getFileName() {
        String host = "";
        if (this.uri == null) {
            try {
                this.assertResolved();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((host = this.uri.getHost()) == null) {
            host = "rel";
        }
        return host + "-" + System.currentTimeMillis() % 1000L + ".webloc";
    }

    public void writeToFile(File f) throws IOException {
        try {
            this.writeToStreamResult(this.createDocument(), new StreamResult(f));
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void print() {
        try {
            this.writeToStreamResult(this.createDocument(), new StreamResult(System.out));
        }
        catch (IOException | ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public BufferedImage readImage(URL u) throws IOException {
        BufferedImage im = WebLocation.readImage(u, this.getUrl());
        this.imageUrl = u;
        return im;
    }

    public static BufferedImage readImage(URL u, URL referrer) throws IOException {
        if ("file".equals(u.getProtocol())) {
            return ImageIO.read(u);
        }
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setRequestProperty("User-Agent", USER_AGENT);
        if (referrer != null) {
            conn.setRequestProperty("Referer", referrer.toExternalForm());
        }
        try (InputStream is = conn.getInputStream();){
            BufferedImage im = ImageIO.read(is);
            if (im == null) {
                throw new IOException("Couldn't read image");
            }
            BufferedImage bufferedImage = im;
            return bufferedImage;
        }
    }

    private static URL resolveRedirectedURL(URL u, int hops) throws IOException {
        if (hops == 0) {
            return u;
        }
        URLConnection conn = u.openConnection();
        conn.setRequestProperty("User-Agent", USER_AGENT);
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
        }
        String location = conn.getHeaderField("Location");
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
        if (location != null) {
            URL url;
            try {
                url = new URL(location);
            }
            catch (MalformedURLException ex) {
                url = new URL(u.getProtocol(), u.getHost(), u.getPort(), IO.urlEncode(location));
            }
            return WebLocation.resolveRedirectedURL(url, --hops);
        }
        return u;
    }

    private static URL resolveRedirectedURL(URL u) throws IOException {
        return WebLocation.resolveRedirectedURL(u, 5);
    }

    public BufferedImage findRepresentingImage() throws IOException {
        Document doc;
        this.assertResolved();
        if (!this.uri.isAbsolute()) {
            return null;
        }
        try {
            doc = Jsoup.parse((URL)WebLocation.toURL(this.uri), (int)2000);
        }
        catch (SSLHandshakeException ex) {
            String content = IO.readTextUrl(WebLocation.toURL(this.uri), new ForgivingSSLSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault()));
            doc = Jsoup.parse((String)content);
        }
        catch (IOException ex) {
            doc = Jsoup.parse((URL)new URL(IO.urlEncode(this.getUrl().toExternalForm())), (int)2000);
        }
        org.jsoup.nodes.Element title = doc.select("head >meta[property=og:title]").first();
        if (title != null && title.hasAttr("content")) {
            this.title = title.attr("content");
        } else {
            title = doc.select("head > title").first();
            if (title != null) {
                this.title = title.text();
            }
        }
        org.jsoup.nodes.Element desc = doc.select("head > meta[property=og:description]").first();
        if (desc != null && desc.hasAttr("content")) {
            this.description = desc.attr("content");
        } else {
            desc = doc.select("head > meta[name=description]").first();
            if (desc != null && desc.hasAttr("content")) {
                this.description = desc.attr("content");
            }
        }
        org.jsoup.nodes.Element meta = doc.select("head > meta[property=og:image]").first();
        if (meta != null) {
            try {
                return this.readImage(new URL(meta.absUrl("content")));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        URL imageURL = StringUtil.resolve((URL)this.getUrl(), (String)"folderimage.jpg");
        try {
            return this.readImage(imageURL);
        }
        catch (IOException iOException) {
            imageURL = StringUtil.resolve((URL)this.getUrl(), (String)"folderthumb.jpg");
            try {
                return this.readImage(imageURL);
            }
            catch (IOException iOException2) {
                String src;
                for (org.jsoup.nodes.Element img : doc.select("img")) {
                    if (!img.hasAttr("src") || !(src = img.absUrl("src").replace(" ", "%20")).contains("thumbs/")) continue;
                    src = src.replace("thumbs/", "slides/");
                    try {
                        return this.readImage(StringUtil.resolve((URL)this.getUrl(), (String)src));
                    }
                    catch (IOException iOException3) {
                    }
                }
                for (org.jsoup.nodes.Element img : doc.select("img")) {
                    if (!img.hasAttr("src")) continue;
                    src = img.absUrl("src").replace(" ", "%20");
                    if (img.hasAttr("width") && img.hasAttr("height")) {
                        int w = 500;
                        int h = 500;
                        try {
                            w = Integer.parseInt(img.attr("width"));
                            h = Integer.parseInt(img.attr("height"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (w < 120 || h < 120) continue;
                        try {
                            return this.readImage(StringUtil.resolve((URL)this.getUrl(), (String)src));
                        }
                        catch (IOException iOException4) {
                            continue;
                        }
                    }
                    BufferedImage bi = this.readImage(new URL(src));
                    if (bi == null || bi.getWidth() <= 120 || bi.getHeight() <= 120) continue;
                    return bi;
                }
                try {
                    URL rssUrl = StringUtil.resolve((URL)this.getUrl(), (String)"album.rss");
                    Document rssDoc = Jsoup.parse((URL)rssUrl, (int)2000);
                    for (org.jsoup.nodes.Element link : rssDoc.select("media|content")) {
                        try {
                            return this.readImage(new URL(link.absUrl("url")));
                        }
                        catch (IOException iOException5) {
                        }
                    }
                }
                catch (HttpStatusException httpStatusException) {
                    // empty catch block
                }
                return null;
            }
        }
    }

    public URL getImageUrl() {
        return this.imageUrl;
    }

    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    public boolean isJsonAlbum() {
        return this.jsonAlbum;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    class ForgivingSSLSocketFactory
    extends SSLSocketFactory {
        SSLSocketFactory factory = null;

        ForgivingSSLSocketFactory(SSLSocketFactory factory) {
            this.factory = factory;
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            Socket skt = this.factory.createSocket(s, host, port, autoClose);
            return this.customizeSSLSocket(skt);
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.factory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket skt = this.factory.createSocket(host, port);
            return this.customizeSSLSocket(skt);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            Socket skt = this.factory.createSocket(host, port);
            return this.customizeSSLSocket(skt);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            Socket skt = this.factory.createSocket(host, port, localHost, localPort);
            return this.customizeSSLSocket(skt);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket skt = this.factory.createSocket(address, port, localAddress, localPort);
            return this.customizeSSLSocket(skt);
        }

        private Socket customizeSSLSocket(Socket sock) throws SocketException {
            if (sock instanceof SSLSocket) {
                SSLSocket skt = (SSLSocket)sock;
                SSLParameters p = skt.getSSLParameters();
                p.setServerNames(new ArrayList<SNIServerName>());
                skt.setSSLParameters(p);
            }
            return sock;
        }
    }
}

