/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import javax.swing.SwingUtilities;
import se.datadosen.component.JNotification;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;

public class Watchdog {
    private static Watchdog theInstance;
    private WatchdogThread watchdogThread;
    private Thread awtThread;
    private long checkInterval = 20000L;
    private boolean enabled = true;
    private final Runnable resetter = new Runnable(){

        @Override
        public void run() {
            if (Watchdog.this.awtThread == null) {
                Watchdog.this.awtThread = Thread.currentThread();
            }
            Watchdog.this.watchdogThread.visit();
        }
    };

    public static Watchdog getInstance() {
        if (theInstance == null) {
            theInstance = new Watchdog();
        }
        return theInstance;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void run() {
        if (this.watchdogThread != null && this.watchdogThread.isAlive()) {
            return;
        }
        this.watchdogThread = new WatchdogThread();
        this.watchdogThread.start();
    }

    public void stop() {
        if (this.watchdogThread.isAlive()) {
            this.watchdogThread.interrupt();
        }
    }

    public boolean isRunning() {
        return this.watchdogThread != null && this.watchdogThread.isAlive();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private class WatchdogThread
    extends Thread {
        private boolean visited;

        public WatchdogThread() {
            super("Watchdog");
            this.visited = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    SwingUtilities.invokeLater(Watchdog.this.resetter);
                    WatchdogThread watchdogThread = this;
                    synchronized (watchdogThread) {
                        this.wait(Watchdog.this.checkInterval);
                    }
                    if (!this.visited && Watchdog.this.enabled) break;
                    this.visited = false;
                }
                JAlbum.dumpThreads();
                JAlbumFrame window = JAlbumContext.getInstance().getFrame();
                if (window != null) {
                    window.showNotification(new JNotification("Full thread dump saved to thread-dump.txt"));
                }
                if (Watchdog.this.awtThread != null) {
                    Watchdog.this.awtThread.interrupt();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void visit() {
            this.visited = true;
        }
    }
}

