/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectImpl;

public class VirtualFolder
extends AlbumObjectImpl {
    protected transient List<AlbumObject> children;
    protected transient Map<String, AlbumObject> nameMap;

    public VirtualFolder(File file, AlbumObject parent, AlbumObjectFactory factory) {
        super(file, parent, factory);
    }

    @Override
    public void add(AlbumObject child) {
        this.getChildren().add(child);
        this.getNameMap().put(child.getName().toLowerCase(), child);
    }

    public void remove(AlbumObject child) {
        this.getChildren().remove(child);
        this.getNameMap().remove(child.getName().toLowerCase());
    }

    public void setParent(AlbumObject newParent) {
        this.parent = newParent;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void setReverseFolderOrdering(boolean reverseFolderOrdering) throws IOException {
    }

    @Override
    public void setReverseOrdering(boolean reverseOrdering) throws IOException {
    }

    @Override
    public void setFoldersFirst(boolean foldersFirst) throws IOException {
    }

    @Override
    public boolean isFoldersFirst() {
        return false;
    }

    @Override
    public void setFolderOrdering(AlbumObject.Ordering folderOrdering) throws IOException {
    }

    @Override
    public AlbumObject.Ordering getFolderOrdering() {
        return AlbumObject.Ordering.custom;
    }

    @Override
    public void setOrdering(AlbumObject.Ordering ordering) throws IOException {
    }

    @Override
    public AlbumObject.Ordering getOrdering() {
        return AlbumObject.Ordering.custom;
    }

    @Override
    protected Map<String, AlbumObject> getNameMap() {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, AlbumObject>();
        }
        return this.nameMap;
    }

    @Override
    public List<AlbumObject> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<AlbumObject>();
        }
        return this.children;
    }

    @Override
    public void setChildren(List<AlbumObject> children) throws IOException {
        this.children = children;
        this.nameMap.clear();
        for (AlbumObject ao : children) {
            this.nameMap.put(ao.getName(), ao);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.children = null;
        this.nameMap = null;
    }
}

