/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.jalbum.views.View;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.VirtualFolder;

public class ViewAlbumObject
extends VirtualFolder {
    private transient AlbumObject viewSource;
    private transient Exception lastException;
    private transient List<AlbumObject> tmpChildren;

    public ViewAlbumObject(File file, AlbumObject parent, AlbumObjectFactory factory) {
        super(file, parent, factory);
    }

    @Override
    public void remove(AlbumObject child) {
        this.safeGetChildren().remove(child);
        this.getNameMap().remove(child.getName().toLowerCase());
    }

    @Override
    public void add(AlbumObject child) {
        this.safeGetChildren().add(child);
        this.getNameMap().put(child.getName().toLowerCase(), child);
    }

    private List<AlbumObject> safeGetChildren() {
        return this.children != null ? this.children : this.tmpChildren;
    }

    @Override
    public Category getCategory() {
        if (this.category == null) {
            this.category = Category.view;
        }
        return super.getCategory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlbumObject> getChildren() {
        if (this.children == null) {
            ViewAlbumObject viewAlbumObject = this;
            synchronized (viewAlbumObject) {
                if (this.children == null) {
                    this.tmpChildren = new ArrayList<AlbumObject>();
                    View view = (View)this.getProperties().get("view");
                    try {
                        this.lastException = null;
                        AlbumObject transformedRoot = view.getTransformer().transform(this.getViewSource(), this);
                        this.children = this.tmpChildren;
                        this.tmpChildren = null;
                    }
                    catch (Exception ex) {
                        System.err.println("Error processing view " + String.valueOf(this) + ": " + String.valueOf(ex));
                        this.lastException = ex;
                    }
                }
            }
        }
        return this.children;
    }

    public AlbumObject getViewSource() {
        if (this.viewSource == null) {
            AlbumObject root = this.getRoot();
            this.viewSource = root.getChild(this.getProperties().get("viewSource", ""));
        }
        return this.viewSource;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

