/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.media.Media;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.jalbum.util.Parameters;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.SlowOperation;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.VideoResolution;
import se.datadosen.util.Debug;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.Orientation;
import se.datadosen.util.Platform;
import se.datadosen.util.Replacer;

public class VideoProcessor {
    protected ProgressMonitor monitor;
    protected boolean allowPrompting = true;
    private static boolean enabled = true;
    protected int videoQuality = 50;
    protected VideoResolution videoResolution = VideoResolution.p720;
    protected Parameters videoParameters;
    private boolean aborted = false;

    boolean isFitting(File file) {
        try {
            String ext = IO.extensionOf(file);
            if (!ext.toLowerCase().equals("mp4")) {
                return false;
            }
            Media media = new Media(file.toURI().toURL().toExternalForm());
            int height = media.getHeight();
            return height <= this.getVideoResolution().getHeight();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private VideoProcessor() {
    }

    public static VideoProcessor createInstance(AlbumBean engine) {
        return Config.getConfig().isVideoSupported() && enabled ? new FfmpegVideoProcessor(engine) : new VideoProcessor();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        VideoProcessor.enabled = enabled;
    }

    public boolean isFormatSupported(File inputVideo) {
        return this.isFormatSupported(IO.extensionOf(inputVideo));
    }

    public boolean isFormatSupported(String ext) {
        return false;
    }

    public boolean isProcessing() {
        return false;
    }

    public Parameters getVideoParameters() {
        if (this.videoParameters == null) {
            this.videoParameters = new Parameters();
        }
        return this.videoParameters;
    }

    public void setVideoParameters(Parameters videoParameters) {
        this.videoParameters = videoParameters;
    }

    public String getVideoSettingsHash() {
        return "";
    }

    public int getVideoQuality() {
        return this.videoQuality;
    }

    public void setVideoQuality(int videoQuality) {
        this.videoQuality = videoQuality;
    }

    public VideoResolution getVideoResolution() {
        return this.videoResolution;
    }

    public void setVideoResolution(VideoResolution videoResolution) {
        this.videoResolution = videoResolution;
    }

    public File getOutputVideoFile(File inputVideo, File outputDir) {
        return new File(outputDir, inputVideo.getName());
    }

    public String getOutputName(String inputName) {
        return IO.baseName(inputName) + ".mp4";
    }

    public File getOldOutputVideoFile(File inputVideo, File outputDir) {
        return new File(outputDir, IO.baseName(inputVideo) + ".mp4");
    }

    public File processVideo(File inputVideo, Orientation orientation, File outputDir) throws IOException, OperationAbortedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public File processVideo(File inputVideo, Orientation orientation, TimeCode clipStart, TimeCode clipLength, File outputDir) throws IOException, OperationAbortedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public VideoInfo createThumbnailFile(File inputVideo, File outputFile) throws IOException, OperationAbortedException {
        return this.createThumbnailFile(inputVideo, outputFile, 1);
    }

    public VideoInfo createThumbnailFile(File inputVideo, File outputFile, int secsFromStart) throws IOException, OperationAbortedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public VideoInfo createThumbnailFile(File inputVideo, File outputFile, TimeCode timeFromStart) throws IOException, OperationAbortedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void abortProcessing() {
        this.aborted = true;
    }

    public void resetAbortedState() {
        this.aborted = false;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isAllowPrompting() {
        return this.allowPrompting;
    }

    public void setAllowPrompting(boolean allowPrompting) {
        this.allowPrompting = allowPrompting;
    }

    public static interface ProgressMonitor {
        public void progress(ProgressInfo var1);
    }

    static class FfmpegVideoProcessor
    extends VideoProcessor {
        private static final Map<String, String> supportedFormats = new HashMap<String, String>();
        private AlbumBean engine;
        private Process process;
        private static final int MIN_KEYFRAME_INTERVAL = 15;
        UserDecision userDecision;

        public FfmpegVideoProcessor(AlbumBean engine) {
            this.engine = engine;
        }

        @Override
        public boolean isFormatSupported(String ext) {
            if (!FfmpegVideoProcessor.isEnabled()) {
                return false;
            }
            boolean supported = Config.getConfig().getSupportedVideoFormats().contains(ext.toLowerCase());
            return supported && this.isExecutableInstalled();
        }

        @Override
        public boolean isProcessing() {
            return this.process != null;
        }

        @Override
        public void abortProcessing() {
            super.abortProcessing();
            if (this.process != null) {
                this.process.destroy();
            }
        }

        @Override
        public String getOutputName(String inputName) {
            return this.getVideoResolution() == VideoResolution.noProcessing ? inputName : IO.baseName(inputName) + ".mp4";
        }

        @Override
        public File getOutputVideoFile(File inputVideo, File outputDir) {
            if (this.getVideoResolution() == VideoResolution.noProcessing) {
                return new File(new File(outputDir, this.engine.getCloseupDirectory()), inputVideo.getName());
            }
            return new File(new File(outputDir, this.engine.getCloseupDirectory()), IO.baseName(inputVideo) + ".mp4");
        }

        private Orientation getOrientationFromOutput(String output) {
            Orientation o = null;
            BufferedReader reader = new BufferedReader(new StringReader(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] tokens = line.split(":");
                    if (tokens.length != 2 || !tokens[0].trim().equals("rotate")) continue;
                    int degrees = Integer.parseInt(tokens[1].trim());
                    switch (degrees) {
                        case 0: {
                            return Orientation.normal;
                        }
                        case 90: {
                            return Orientation.left;
                        }
                        case 180: {
                            return Orientation.upsideDown;
                        }
                        case 270: {
                            return Orientation.right;
                        }
                    }
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return o;
        }

        private TimeCode getDurationFromOutput(String output) {
            BufferedReader reader = new BufferedReader(new StringReader(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("Duration:")) continue;
                    return new TimeCode(line.substring("Duration:".length()));
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                System.err.println(ex);
            }
            return null;
        }

        private Integer getgetFPSFromOutput(String output) {
            BufferedReader reader = new BufferedReader(new StringReader(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    int start;
                    if (!(line = line.trim()).startsWith("Stream") || !line.contains("fps")) continue;
                    int fpsIndex = line.indexOf("fps");
                    for (start = fpsIndex - 1; start > 0 && (Character.isWhitespace(line.charAt(start)) || Character.isDigit(line.charAt(start))); --start) {
                    }
                    return Integer.valueOf(line.substring(start + 1, fpsIndex).trim());
                }
            }
            catch (IOException | NumberFormatException ex) {
                System.err.println(ex);
            }
            return null;
        }

        private Dimension getDimensionFromOutput(String output) {
            BufferedReader reader = new BufferedReader(new StringReader(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("Stream") || !line.contains("Video:")) continue;
                    String[] dim = FfmpegVideoProcessor.skipParenthesis(line).split(",")[2].trim().split(" ")[0].split("x");
                    return new Dimension(Integer.parseInt(dim[0]), Integer.parseInt(dim[1]));
                }
            }
            catch (IOException | NumberFormatException ex) {
                System.err.println(ex);
            }
            return null;
        }

        private static String skipParenthesis(String s) {
            StringBuilder buf = new StringBuilder();
            int level = 0;
            for (char c : s.toCharArray()) {
                if (c == '(') {
                    ++level;
                } else if (c == ')') {
                    --level;
                }
                if (level > 0) continue;
                buf.append(c);
            }
            return buf.toString();
        }

        @Override
        public VideoInfo createThumbnailFile(File inputVideo, File outputFile, int secsFromStart) throws IOException, OperationAbortedException {
            return this.createThumbnailFile(inputVideo, outputFile, new TimeCode(secsFromStart));
        }

        @Override
        public synchronized VideoInfo createThumbnailFile(File inputVideo, File outputFile, TimeCode timeFromStart) throws IOException {
            try {
                return this.doCreateThumbnailFile(inputVideo, outputFile, timeFromStart);
            }
            catch (IOException ex) {
                return this.doCreateThumbnailFile(inputVideo, outputFile, new TimeCode(0));
            }
        }

        private VideoInfo doCreateThumbnailFile(File inputVideo, File outputFile, TimeCode timeFromStart) throws IOException {
            if (timeFromStart == null) {
                timeFromStart = new TimeCode(1);
            }
            File targetFile = new File(outputFile.getParentFile(), IO.baseName(outputFile) + ".jpg");
            File tmpFile = File.createTempFile("videoslide-", ".jpg");
            tmpFile.delete();
            File exe = this.getExecutable();
            ArrayList<String> args = new ArrayList<String>();
            args.add(exe.getAbsolutePath());
            if (timeFromStart.getSecs() > 15) {
                args.add("-ss");
                TimeCode earlier = new TimeCode(timeFromStart.getSecs() - 15);
                args.add(earlier.toString());
                timeFromStart.setSecs(timeFromStart.getSecs() - earlier.getSecs());
            }
            args.add("-i");
            args.add(inputVideo.getAbsolutePath());
            args.add("-vf");
            args.add("scale=iw*sar:ih");
            args.add("-an");
            args.add("-ss");
            args.add(timeFromStart.toString());
            args.add("-vframes");
            args.add("1");
            args.add(tmpFile.getAbsolutePath());
            Debug.log("Executing " + FfmpegVideoProcessor.toCommandLine(args));
            this.process = new ProcessBuilder(new String[0]).command(args).start();
            AsyncStreamReader stdOutReader = new AsyncStreamReader(this.process.getInputStream(), null, "StdOut");
            AsyncStreamReader stdErrReader = new AsyncStreamReader(this.process.getErrorStream(), null, "StdErr");
            try {
                stdOutReader.start();
                stdErrReader.start();
                this.process.waitFor();
                if (this.process.exitValue() != 0) {
                    throw new IOException("Error during video thumbnail creation for " + String.valueOf(inputVideo) + ".\nffmpeg process terminated abnormally with code " + this.process.exitValue() + ":\n" + stdErrReader.getBuffer());
                }
                if (!tmpFile.exists()) {
                    throw new IOException("Error during video thumbnail creation for " + String.valueOf(inputVideo) + ".\nffmpeg process reports: " + stdErrReader.getErrorLine());
                }
                IO.copyFile(tmpFile, targetFile, true);
                tmpFile.delete();
                Tracer.getInstance().trace("processed video thumbnail");
                Orientation o = this.getOrientationFromOutput(stdErrReader.getBuffer());
                Integer fps = this.getgetFPSFromOutput(stdErrReader.getBuffer());
                TimeCode duration = this.getDurationFromOutput(stdErrReader.getBuffer());
                if (o == null) {
                    o = Orientation.normal;
                }
                Dimension dim = this.getDimensionFromOutputFile(targetFile);
                VideoInfo videoInfo = new VideoInfo(o, duration, fps, dim);
                return videoInfo;
            }
            catch (InterruptedException t) {
                throw new IOException(t);
            }
            finally {
                this.process = null;
                stdOutReader.abort();
                stdErrReader.abort();
            }
        }

        @Override
        public Parameters getVideoParameters() {
            Parameters vp = this.videoParameters;
            if (vp == null) {
                vp = this.videoParameters = new Parameters();
                vp.add("-y", "");
                vp.add("-i", "$inputPath");
                if (this.videoResolution != VideoResolution.original) {
                    vp.add("-vf", "hqdn3d=1.5:1.5:6:6,scale=min(iw\\,trunc(iw*min($videoWidth/iw\\,$videoHeight/ih)*0.5)*2):min(ih\\,trunc(ih*min($videoWidth/iw\\,$videoHeight/ih)*0.5)*2),unsharp=3:3:1.0:3:3:0.0,$normalizeOrientation");
                } else {
                    vp.add("-vf", "$normalizeOrientation");
                }
                vp.add("-ss", "$clipStart");
                vp.add("-t", "$clipLength");
                vp.add("-threads", "0");
                vp.add("-b:a", "96k");
                vp.add("-ac", "2");
                vp.add("-ar", "44100");
                vp.add("-vcodec", "libx264");
                vp.add("-crf", "$videoQuality");
                vp.add("-metadata:s:v:0", "rotate=0");
                vp.add("-movflags", "faststart");
                vp.add("-pix_fmt", "yuv420p");
                vp.add("$outputPath", "");
            }
            return vp;
        }

        @Override
        public void setVideoParameters(Parameters videoParameters) {
            if (videoParameters != null && videoParameters.isEmpty()) {
                videoParameters = null;
            }
            this.videoParameters = videoParameters;
            if (videoParameters != null && "libvo_aacenc".equals(videoParameters.get("-acodec"))) {
                videoParameters.remove("-acodec");
            }
        }

        @Override
        public File processVideo(File inputVideo, Orientation orientation, File outputDir) throws IOException, OperationAbortedException {
            return this.processVideo(inputVideo, orientation, null, null, outputDir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File processVideo(File inputVideo, Orientation orientation, TimeCode clipStart, TimeCode clipLength, File outputDir) throws IOException, OperationAbortedException {
            File outputVideo = this.getOutputVideoFile(inputVideo, outputDir);
            outputVideo.getParentFile().mkdir();
            if (this.getVideoResolution() == VideoResolution.noProcessing) {
                IO.copyFile(inputVideo, outputVideo, !this.engine.isAppendImages(), Config.getConfig().isUseHardLinks());
                return outputVideo;
            }
            Class<FfmpegVideoProcessor> clazz = FfmpegVideoProcessor.class;
            synchronized (FfmpegVideoProcessor.class) {
                if (this.isAborted()) {
                    throw new OperationAbortedException();
                }
                if (outputVideo.equals(inputVideo)) {
                    System.err.println("Skipping processing of " + inputVideo.getName() + ". Processing would overwrite original video. Don't output to image directory.");
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return outputVideo;
                }
                outputVideo.delete();
                File exe = this.getExecutable();
                List<String> args = this.prepareArguments(exe, inputVideo, orientation, clipStart, clipLength, outputVideo);
                Debug.log("Executing " + FfmpegVideoProcessor.toCommandLine(args));
                Process myProcess = this.process = new ProcessBuilder(new String[0]).command(args).start();
                AsyncStreamReader stdOutReader = new AsyncStreamReader(this.process.getInputStream(), clipLength, "StdOut");
                AsyncStreamReader stdErrReader = new AsyncStreamReader(this.process.getErrorStream(), clipLength, "StdErr");
                stdErrReader.setMonitor(this.monitor);
                try {
                    stdOutReader.start();
                    stdErrReader.start();
                    myProcess.waitFor();
                    if (myProcess.exitValue() != 0) {
                        outputVideo.delete();
                        if (!stdErrReader.isAborted()) {
                            System.err.println("Error during ffmpeg video processing:\n" + stdErrReader.getBuffer());
                            throw new IOException("Error during video creation. Please review video settings. \nffmpeg process terminated abnormally with code " + this.process.exitValue() + ":\n" + stdErrReader.getErrorLine());
                        }
                    }
                    if (stdErrReader.isAborted()) {
                        throw new OperationAbortedException();
                    }
                    Tracer.getInstance().trace("processed video");
                }
                catch (InterruptedException t) {
                    t.printStackTrace(System.out);
                }
                finally {
                    this.process = null;
                    stdOutReader.abort();
                    stdErrReader.abort();
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return outputVideo;
            }
        }

        @Override
        public String getVideoSettingsHash() {
            return DigestUtil.md5(this.getVideoParametersAsString());
        }

        private String getVideoParametersAsString() {
            List<String> args = this.prepareArguments(null, null, Orientation.normal, null, null, null);
            StringBuilder builder = new StringBuilder();
            for (String arg : args) {
                builder.append(arg);
                builder.append(' ');
            }
            return builder.toString().trim();
        }

        private static String toCommandLine(List<String> args) {
            StringBuilder builder = new StringBuilder();
            for (String arg : args) {
                builder.append(arg);
                builder.append(' ');
            }
            return builder.toString().trim();
        }

        private List<String> prepareArguments(File executable, File inputVideo, Orientation orientation, TimeCode clipStart, TimeCode clipLength, File outputVideo) {
            String inputPath = "";
            String outputPath = "";
            ArrayList<String> args = new ArrayList<String>();
            Replacer r = new Replacer();
            if (inputVideo != null && outputVideo != null) {
                inputPath = inputVideo.getAbsolutePath();
                outputPath = outputVideo.getAbsolutePath();
                r.add("$fileName", inputVideo.getName());
                r.add("$label", IO.baseName(inputVideo));
                r.add("$inputDirectory", inputVideo.getParentFile().getAbsolutePath());
                r.add("$outputDirectory", outputVideo.getParentFile().getAbsolutePath());
            }
            r.add("$projectPath", this.engine.getDirectory());
            r.add("$inputPath", inputPath);
            r.add("$outputPath", outputPath);
            r.add("$videoQuality", "" + (40 - 24 * this.videoQuality / 100));
            boolean rotated = orientation == Orientation.left || orientation == Orientation.right;
            r.add("$videoWidth", "" + (rotated ? this.videoResolution.getHeight() : this.videoResolution.getWidth()));
            r.add("$videoHeight", "" + (rotated ? this.videoResolution.getWidth() : this.videoResolution.getHeight()));
            r.add("$normalizeOrientation", this.normalize(orientation));
            r.add("$clipStart", clipStart != null ? clipStart.toString() : "");
            r.add("$clipLength", clipLength != null ? clipLength.toString() : "");
            if (executable != null) {
                args.add(executable.getAbsolutePath());
            }
            Parameters params = this.getVideoParameters();
            boolean codecPresent = params.containsKey("-acodec");
            for (Map.Entry<String, String> e : params) {
                String key = r.replace(e.getKey()).trim();
                String value = r.replace(e.getValue()).trim();
                if ("-vf".equals(key) || "-ss".equals(key) || "-t".equals(key)) {
                    if (value.length() == 0) continue;
                    if (value.endsWith(",")) {
                        value = value.substring(0, value.length() - 1);
                    }
                }
                if (key.length() > 0) {
                    args.add(key);
                }
                if (value.length() > 0) {
                    args.add(value);
                }
                if (executable != null || codecPresent || !key.equals("-threads")) continue;
                args.add("-acodec");
                args.add("libvo_aacenc");
            }
            return args;
        }

        private String normalize(Orientation orientation) {
            switch (orientation) {
                case left: {
                    return "transpose=1";
                }
                case right: {
                    return "transpose=2";
                }
                case upsideDown: {
                    return "hflip,vflip";
                }
            }
            return "";
        }

        private Dimension getDimensionFromOutputFile(File tmpOut) throws IOException {
            FileFilters.BasicImageInfo ii = FileFilters.getBasicImageInfo(tmpOut);
            return ii.getSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private File getExecutable() throws IOException, OperationAbortedException, DisabledException {
            final File exe = new File(MiniConfig.getMiniConfig().configDir, "bin/" + (Platform.isWindows() ? "ffmpeg.exe" : "ffmpeg"));
            if (exe.exists()) return exe;
            Class<FfmpegVideoProcessor> clazz = FfmpegVideoProcessor.class;
            synchronized (FfmpegVideoProcessor.class) {
                if (exe.exists()) return exe;
                JAlbumFrame window = JAlbumContext.getInstance().getFrame();
                if (window == null || !this.isAllowPrompting()) {
                    throw new OperationAbortedException();
                }
                try {
                    Runnable r = () -> {
                        int res = JOptionPane.showOptionDialog(window, Msg.get("ui.videoSupportInfo"), Msg.get("prefs.videoSupport"), 0, 1, null, new Object[]{Msg.get("add"), Msg.get("ui.disable")}, Msg.get("add"));
                        switch (res) {
                            case -1: {
                                this.userDecision = UserDecision.closed;
                                break;
                            }
                            case 0: {
                                this.userDecision = UserDecision.add;
                                break;
                            }
                            case 1: {
                                this.userDecision = UserDecision.disabled;
                                FfmpegVideoProcessor.setEnabled(false);
                                window.preferencesWindow.videoSupported.setSelected(false);
                                window.preferencesWindow.savePreferences();
                                JOptionPane.showMessageDialog(window, Msg.get("ui.videoSupportDisabledInfo"), Msg.get("prefs.videoSupport"), 1);
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        r.run();
                    } else {
                        this.userDecision = UserDecision.add;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                switch (this.userDecision.ordinal()) {
                    case 0: {
                        FfmpegVideoProcessor.setEnabled(false);
                        throw new OperationAbortedException();
                    }
                    case 1: {
                        throw new DisabledException();
                    }
                    case 2: {
                        String statusText = Msg.get("ui.downloadingVideoSupport", "jalbum.net");
                        System.out.println(statusText);
                        exe.getParentFile().mkdir();
                        if (SwingUtilities.isEventDispatchThread()) {
                            SlowOperation so = new SlowOperation(this){
                                final /* synthetic */ FfmpegVideoProcessor this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public void operation() throws Throwable {
                                    this.this$0.downloadExecutable(exe);
                                }

                                @Override
                                public void abort() {
                                    this.interrupt();
                                    this.dialog.setVisible(enabled);
                                }
                            };
                            try {
                                so.launch(window, Msg.get("ui.downloadingVideoSupport", "jalbum.net"), Msg.get("prefs.videoSupport"));
                                break;
                            }
                            catch (Throwable ex) {
                                if (!(ex instanceof IOException)) throw new RuntimeException(ex);
                                throw (IOException)ex;
                            }
                        }
                        if (window != null) {
                            window.progressSpinner.workStarted();
                            window.statusBar.pushText(statusText);
                        }
                        try {
                            this.downloadExecutable(exe);
                            SwingUtilities.invokeLater(() -> window.albumExplorer.refreshAction.actionPerformed(null));
                            if (window == null) return exe;
                            window.progressSpinner.workDone();
                            window.statusBar.popText(statusText);
                            break;
                        }
                        catch (Throwable throwable) {
                            if (window == null) throw throwable;
                            window.progressSpinner.workDone();
                            window.statusBar.popText(statusText);
                            throw throwable;
                        }
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return exe;
            }
        }

        private void downloadExecutable(File exe) throws IOException {
            try {
                IO.downloadZipFile(this.getExecutableURL("ffmpeg.zip"), exe.getParentFile());
            }
            catch (IOException ex) {
                try {
                    IO.downloadFile(this.getExecutableURL(Platform.isWindows() ? "ffmpeg.exe" : "ffmpeg"), exe.getParentFile());
                }
                catch (IOException ex2) {
                    exe.delete();
                    throw ex2;
                }
            }
            if (exe.length() < 0x500000L) {
                exe.delete();
                throw new IOException("Problem downloading video support from jalbum.net. Please try again later");
            }
            exe.setExecutable(true);
        }

        private URL getExecutableURL(String fileName) {
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            StringTokenizer tokens = new StringTokenizer(os);
            os = tokens.nextToken();
            try {
                return new URL(JAlbumSite.getInstance().getBinariesUrl() + "/" + os + "/" + arch + "/" + fileName);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }

        private boolean isExecutableInstalled() {
            try {
                this.getExecutable();
                return true;
            }
            catch (IOException ex) {
                FfmpegVideoProcessor.setEnabled(false);
                Debug.showErrorDialog(null, ex);
                ex.printStackTrace(System.err);
            }
            catch (OperationAbortedException | DisabledException runtimeException) {
                // empty catch block
            }
            return false;
        }

        static enum UserDecision {
            closed,
            disabled,
            add;

        }
    }

    public static class VideoInfo {
        public Orientation orientation;
        public TimeCode duration;
        Integer fps;
        Dimension dim;

        public VideoInfo(Orientation orientation, TimeCode duration, Integer fps, Dimension dim) {
            this.orientation = orientation;
            this.duration = duration;
            this.fps = fps;
            this.dim = dim;
        }
    }

    private static class AsyncStreamReader
    extends Thread {
        private StringWriter buffer;
        String lastLine;
        private TimeCode clipLength;
        private InputStream inputStream;
        private String threadId;
        private boolean aborted = false;
        private ProgressMonitor monitor;
        private Pattern pattern = Pattern.compile("(\\w+)=\\s*([^\\s]+)");

        public ProgressMonitor getMonitor() {
            return this.monitor;
        }

        public void setMonitor(ProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public AsyncStreamReader(InputStream inputStream, TimeCode clipLength, String threadId) {
            super(threadId);
            this.inputStream = inputStream;
            this.clipLength = clipLength;
            this.buffer = new StringWriter();
            this.threadId = threadId;
        }

        public String getBuffer() {
            return this.buffer.toString();
        }

        public String getErrorLine() {
            return this.lastLine;
        }

        @Override
        public void run() {
            try {
                this.readCommandOutput();
            }
            catch (OperationAbortedException ex) {
                this.aborted = true;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                System.err.println("Could not read command output: " + String.valueOf(ex));
            }
        }

        private void readCommandOutput() throws IOException {
            PrintWriter out;
            long progressMillis = 0L;
            try (BufferedReader bufOut = new BufferedReader(new InputStreamReader(this.inputStream));){
                out = new PrintWriter(this.buffer);
                String line = null;
                long durationMillis = -1L;
                while (!this.aborted && (line = bufOut.readLine()) != null) {
                    this.lastLine = line;
                    out.println(line);
                    Debug.log(line);
                    line = line.trim();
                    if (line.startsWith("Duration:") && durationMillis == -1L) {
                        durationMillis = this.toMillis(line.split(" |,")[1]);
                    }
                    if (this.clipLength != null) {
                        durationMillis = this.clipLength.asMillis();
                    }
                    if (!line.startsWith("frame=")) continue;
                    try {
                        String speed;
                        HashMap<String, String> map = new HashMap<String, String>();
                        Matcher matcher = this.pattern.matcher(line);
                        while (matcher.find()) {
                            String key = matcher.group(1);
                            String value = matcher.group(2);
                            map.put(key, value);
                        }
                        long time = this.toMillis((String)map.get("time"));
                        if (time > 0L) {
                            progressMillis = time;
                        }
                        if (this.monitor == null) continue;
                        if (progressMillis > durationMillis) {
                            progressMillis = durationMillis;
                        }
                        if ("N/A".equals(speed = (String)map.get("speed"))) {
                            speed = null;
                        }
                        this.monitor.progress(new ProgressInfo(progressMillis, durationMillis, speed));
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("Can't parse ffmpeg status line: " + line);
                    }
                }
            }
            out.close();
        }

        private long toMillis(String hhmmssdd) {
            if ("N/A".equals(hhmmssdd)) {
                return -1L;
            }
            StringTokenizer tokens = new StringTokenizer(hhmmssdd, ":");
            long millis = 3600000 * Integer.parseInt(tokens.nextToken());
            millis += (long)(60000 * Integer.parseInt(tokens.nextToken()));
            return millis += (long)(1000.0f * Float.parseFloat(tokens.nextToken()));
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void abort() {
            this.aborted = true;
        }
    }

    private static class DisabledException
    extends RuntimeException {
        private DisabledException() {
        }
    }

    public static class ProgressInfo {
        final long currentMillis;
        final long durationMillis;
        final String speed;

        public ProgressInfo(long currentMillis, long durationMillis, String speed) {
            this.currentMillis = currentMillis;
            this.durationMillis = durationMillis;
            this.speed = speed;
        }
    }
}

