/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.SwingUtilities;
import net.jalbum.component.Dialogs;
import net.jalbum.component.JProgressManager;
import se.datadosen.component.JNotification;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.DataRate;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.TaskManager;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.event.ByteProgressEvent;
import se.datadosen.jalbum.event.FileProgressEvent;
import se.datadosen.jalbum.event.ProgressEvent;
import se.datadosen.jalbum.event.TransferListener;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Debug;
import se.datadosen.util.StringUtil;

public class UploadAlbumTask
extends TaskManager.BackgroundTask
implements TransferListener {
    AlbumBean engine;
    UploadBean uploadBean;
    private final Object pauseMonitor = new Object();
    JProgressManager.TaskStatus ts = new JProgressManager.TaskStatus();
    JAlbumFrame window;
    PrintStream log;
    String albumURL;
    private DataRate rate = new DataRate();
    long lastUpdateTime;

    public UploadAlbumTask(AlbumBean engine, JAlbumFrame window, PrintStream log) {
        super(engine.getCurrentProject());
        this.init(engine, window, log);
    }

    public UploadAlbumTask(AlbumProject ap, JAlbumContext context, JAlbumFrame window, PrintStream log) throws IOException {
        super(ap);
        AlbumBean engine = new AlbumBean(context);
        Properties props = JAlbumUtilities.importProject(ap.getProjectFile());
        engine.setProperties(props);
        engine.setCurrentProject(ap);
        this.init(engine, window, log);
    }

    private void init(AlbumBean engine, JAlbumFrame window, PrintStream log) {
        this.engine = engine;
        this.window = window;
        this.log = log;
        this.setName(StringUtil.limit(this.ap.getName(), 30) + " (" + Msg.get("ui.uploadTaskShortName") + ")");
        this.ts.setMessage(this.getName());
        this.ts.onAbort(() -> {
            Object object = this.pauseMonitor;
            synchronized (object) {
                window.statusBar.setText(Msg.get("ui.aborting"));
                this.ts.abort();
                UploadBean ub = this.uploadBean;
                if (ub != null) {
                    this.uploadBean.cancelUpload();
                }
                this.cancel();
                this.pauseMonitor.notifyAll();
            }
            window.progressManager.removeTask(this.ts);
        });
        this.ts.onPause(() -> {
            Object object = this.pauseMonitor;
            synchronized (object) {
                if (!this.ts.isPaused()) {
                    this.pauseMonitor.notifyAll();
                }
            }
        });
        this.onError(ex -> {
            this.ap.lastExceptionProperty.set(ex);
            JNotification n = new JNotification(Msg.get("ui.errorUploadingProject", this.ap.getName(), "<a href=\"about:blank\">" + ex.getMessage() + "</a>"), JNotification.Type.ERROR);
            n.onLinkClicked(he -> {
                n.setVisible(false);
                Debug.showErrorDialog(window, ex);
            });
            window.showNotification(n);
        });
        this.ts.setProgress("");
    }

    @Override
    protected Object doInBackground() throws Exception {
        this.ap.lastExceptionProperty.set(null);
        this.window.progressManager.startTask(this.ts);
        try (UploadBean uploadBean = new UploadBean();){
            this.uploadBean = uploadBean;
            uploadBean.addTransferListener(this);
            AccountProfile account = AccountManager.getInstance().findAccountByName(this.engine.getAccountProfileName());
            if (account == null) {
                account = AccountManager.getInstance().getFirstMyjalbumAccount();
            }
            if (account == null) {
                throw new IllegalStateException(Msg.get("ui.accountProfileNotFoundError"));
            }
            if (account.isMyjalbum() && this.engine.getRemoteDirectory().length() == 0) {
                this.engine.setRemoteDirectory(this.engine.getCurrentProject().getName());
            }
            uploadBean.setAccountProperties(account);
            uploadBean.setEngine(this.engine);
            this.albumURL = uploadBean.getPrintableAlbumURL();
            String oldAlbumURL = this.ap.getRootFolder().getProperties().get("albumURL", "");
            if (!this.albumURL.equals(oldAlbumURL)) {
                String okOption = Msg.get("ok");
                String cancelOption = Msg.get("cancel");
                String changeLocationOption = Msg.get("ui.changeLocation");
                String answer = (String)Dialogs.showOptionDialog(this.window, Msg.get("publish.uploadConfirmation", this.albumURL), Msg.get("ui.uploadInBackground"), 1, new Object[]{okOption, cancelOption, changeLocationOption}, okOption);
                if (answer != okOption) {
                    if (answer == changeLocationOption) {
                        SwingUtilities.invokeLater(() -> this.window.actions.showPublishWindowAction.actionPerformed(null));
                    }
                    throw new OperationAbortedException();
                }
            }
            this.window.statusBar.setText(Msg.get("ui.uploadingAlbumStarted", this.engine.getCurrentProject().getName(), this.albumURL));
            uploadBean.connect();
            uploadBean.uploadAlbum(this.engine, false);
        }
        catch (OperationAbortedException ex) {
            String message = ex.getMessage() != null ? ex.getMessage() : Msg.get("ui.uploadAborted");
            this.window.statusBar.setText(message);
            System.out.println(message);
            throw ex;
        }
        return null;
    }

    @Override
    protected void done() {
        this.window.progressManager.removeTask(this.ts);
        SwingUtilities.invokeLater(() -> {
            if (this.completedNormally()) {
                this.window.fixUIdisabling();
                String msg = Msg.get("ui.uploadingAlbumDone", this.ap.getName(), this.albumURL, this.uploadBean.getStopwatch());
                this.window.statusBar.setText(msg);
                JNotification n = new JNotification(msg + ". <a href=\"about:blank\">" + Msg.get("ui.view") + "</a>", JNotification.Type.INFO);
                n.onLinkClicked(he -> {
                    try {
                        n.setDismissed(true);
                        this.window.openInBrowser(this.ap, new URL(this.albumURL), null);
                    }
                    catch (MalformedURLException ex) {
                        Debug.showErrorDialog(this.window, ex);
                    }
                });
                n.setExpiration(8);
                this.window.multiMaker.showNotification(n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgress(ProgressEvent e) {
        Object object = this.pauseMonitor;
        synchronized (object) {
            if (this.ts.isPaused()) {
                try {
                    this.pauseMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.ts.setSubMessage(e.msg);
        this.ts.setIndeterminate(e.isIndeterminate());
        if (!e.isIndeterminate()) {
            if (e instanceof ByteProgressEvent) {
                this.rate.update(e.processed);
                this.ts.setProgress(DataSizeFormatter.formatXofY("progress.processingInfo2", e.processed, e.total), "  (" + String.valueOf(this.rate) + ")", (int)(e.processed / 100L), (int)(e.total / 100L));
            } else if (e instanceof FileProgressEvent) {
                this.ts.setProgress(Msg.get("upload.processingInfo2", e.processed, e.total), (int)e.processed, (int)e.total);
            }
        } else {
            this.ts.setProgress("");
        }
    }

    @Override
    public void progress(ProgressEvent e) {
        this.updateProgress(e);
    }

    @Override
    public void fileProcessingStarted(ProgressEvent e) {
        if (this.ts.isAborted()) {
            throw new OperationAbortedException(Msg.get("ui.uploadAborted"));
        }
        this.updateProgress(e);
    }

    @Override
    public void fileProcessingFinished(ProgressEvent e) {
        if (this.ts.isAborted()) {
            throw new OperationAbortedException(Msg.get("ui.uploadAborted"));
        }
        this.updateProgress(e);
    }

    @Override
    public void errorOccured(Throwable t, File f) {
    }

    @Override
    public void fileProcessingProgress(ProgressEvent e) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime < 500L) {
            return;
        }
        this.lastUpdateTime = currentTime;
        this.updateProgress(e);
    }
}

