/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public abstract class TypeNavigator
implements KeyListener {
    private static final int WORD_THRESHOLD = 800;
    private String prefix = "X";
    private long lastPressedTime = 0L;

    public TypeNavigator() {
    }

    public TypeNavigator(Component comp) {
        comp.addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        long now = System.currentTimeMillis();
        char c = Character.toLowerCase(e.getKeyChar());
        if (e.getModifiersEx() == 0 && Character.isLetterOrDigit(c)) {
            if (now - this.lastPressedTime < 800L && (this.prefix.length() > 1 || c != this.prefix.charAt(this.prefix.length() - 1))) {
                this.prefix = this.prefix + c;
                String fn = this.getFocusedName();
                if (fn != null && !fn.toLowerCase().startsWith(this.prefix)) {
                    this.focusNextMatching(this.prefix);
                }
            } else {
                this.prefix = String.valueOf(c);
                this.focusNextMatching(this.prefix);
            }
            this.lastPressedTime = now;
        }
    }

    public abstract String getFocusedName();

    public abstract void focusNextMatching(String var1);

    protected boolean isMatch(String name) {
        return name.toLowerCase().startsWith(this.prefix);
    }

    protected int indexOf(Component comp, Component[] comps) {
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != comp) continue;
            return i;
        }
        return -1;
    }
}

