/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import net.jalbum.filters.CropFilter;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.EmbeddedProperties;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.util.FileFilters;
import se.datadosen.util.GraphicsUtilities;

public class ThemeImageProcessor {
    public static final String THEME_FILE_NAME = "folderimage.jpg";
    protected AlbumBean engine;

    public void setEngine(AlbumBean engine) {
        this.engine = engine;
    }

    public String getThemePath(AlbumObject folder) {
        return THEME_FILE_NAME;
    }

    public Dimension getFinalThemeImageDim(AlbumObject folder) {
        try {
            Dimension themeDim = this.engine.getThemeImageDim();
            AlbumObject theme = JAlbumUtilities.getThemeObject(folder);
            if (theme != null) {
                FileFilters.BasicImageInfo ii = theme.getImageInfo();
                int width = ii.width;
                int height = ii.height;
                if (themeDim != null) {
                    double ratio = (double)themeDim.width / (double)themeDim.height;
                    Dimension cropRect = new Dimension(width, (int)((double)width / ratio));
                    if (cropRect.height > height) {
                        cropRect = new Dimension((int)((double)height * ratio), height);
                    }
                    return GraphicsUtilities.fitWithinBounds(cropRect.width, cropRect.height, themeDim);
                }
                return new Dimension(ii.width, ii.height);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void processThemeImage(AlbumObject folder, File outputDir) throws IOException {
        AlbumObject theme = JAlbumUtilities.getThemeObject(folder);
        Dimension themeDim = this.engine.getThemeImageDim();
        if (theme != null) {
            if (themeDim == null) {
                themeDim = new Dimension(theme.getImageInfo().width, theme.getImageInfo().height);
            }
            File themeFile = new File(outputDir, this.getThemePath(folder));
            EmbeddedProperties existing = new EmbeddedProperties(themeFile);
            EmbeddedProperties current = new EmbeddedProperties();
            current.put("themeSrc", theme.getPathFrom(folder));
            current.put("themeDim", themeDim.width + "x" + themeDim.height);
            if (!this.engine.isAppendImages() || JAlbumUtilities.isDirty(themeFile, theme) || !existing.equals(current)) {
                JAlbum.logger.log(Level.FINE, "Generating theme image for {0}", folder);
                AlbumImage ai = new AlbumImage(theme);
                if (this.engine.getThemeImageDim() != null) {
                    CropFilter cf = new CropFilter();
                    double ratio = (double)themeDim.width / (double)themeDim.height;
                    int width = ai.getBufferedImage().getWidth();
                    int height = ai.getBufferedImage().getHeight();
                    Dimension bounds = new Dimension(width, (int)((double)width / ratio));
                    if (bounds.height > height) {
                        bounds = new Dimension((int)((double)height * ratio), height);
                    }
                    cf.setBounds(bounds);
                    ai = ai.applyFilter(cf, theme.getVars());
                    ai = ai.scaleToFit(themeDim);
                }
                ai.saveImage(themeFile);
                try {
                    current.write(themeFile);
                }
                catch (IOException ex) {
                    System.err.println("Can't write properties for theme image " + themeFile.getName() + ": " + ex.getMessage());
                }
            }
        }
    }
}

