/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import javax.swing.text.JTextComponent;

public class TextEditor {
    private static final String START_STRING = "";
    private static final String END_STRING = ": at Line: ";
    private static Editor theEditor;

    private static String cleanMessage(String message) {
        Object cleaned = message;
        if (message == null) {
            return null;
        }
        int start = 0;
        int end = message.indexOf(END_STRING);
        int target = message.indexOf("Target exception: ");
        if (start > -1 && end > -1) {
            cleaned = end < start ? message.substring(start + START_STRING.length()) : message.substring(start + START_STRING.length(), end);
            if (target > -1) {
                cleaned = (String)cleaned + "\n\n" + message.substring(target);
            }
        }
        return cleaned;
    }

    private TextEditor() {
    }

    public static boolean openDocument(File f) {
        if (theEditor != null) {
            theEditor.openDocument(f);
            return true;
        }
        return false;
    }

    public static boolean openDocument(File f, int lineNumber) {
        if (theEditor != null) {
            theEditor.openDocument(f, lineNumber);
            return true;
        }
        return false;
    }

    public static boolean openDocument(File f, int lineNumber, int columnNumber) {
        if (theEditor != null) {
            theEditor.openDocument(f, lineNumber, columnNumber);
            return true;
        }
        return false;
    }

    public static boolean openDocument(File f, int lineNumber, int columnNumber, String message) {
        if (theEditor != null) {
            theEditor.openDocument(f, lineNumber, columnNumber, TextEditor.cleanMessage(message));
            return true;
        }
        return false;
    }

    public static JTextComponent getCurrentEditorComponent() {
        if (theEditor != null) {
            return theEditor.getCurrentEditorComponent();
        }
        return null;
    }

    public static JTextComponent newDocument() {
        if (theEditor != null) {
            return theEditor.newDocument();
        }
        return null;
    }

    public static boolean isInstalled() {
        return theEditor != null;
    }

    public static void install(Editor editor) {
        theEditor = editor;
    }

    public static interface Editor {
        public void openDocument(File var1);

        public void openDocument(File var1, int var2);

        public void openDocument(File var1, int var2, int var3);

        public void openDocument(File var1, int var2, int var3, String var4);

        public JTextComponent newDocument();

        public JTextComponent getCurrentEditorComponent();
    }
}

