/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.util.IO;

class Targets {
    public final String main;
    public final String thumb;
    public final String closeup;

    private Targets(AlbumObject ao) {
        this.main = ao.getName();
        AlbumBean engine = ao.getEngine();
        if (ao.isFolder() && ao.getEngine().isProcessFolderThumbs()) {
            this.thumb = engine.getTargetThumbName(ao.getFile());
            this.closeup = engine.getTargetName(ao.getFile());
            return;
        }
        AlbumObject orig = ao;
        if ((ao = orig.getRepresentingAlbumObject()) == null) {
            ao = orig;
        }
        File file = ao.getFile();
        File repImage = ao.getRepresentingImageFile();
        if (repImage != null) {
            file = new LinkFile(file.getParentFile(), IO.baseName(file.getName()) + "." + IO.extensionOf(repImage), repImage);
        }
        this.thumb = engine.getTargetThumbName(file);
        this.closeup = engine.getTargetName(file);
    }

    public static Targets of(AlbumObject ao) {
        return new Targets(ao);
    }
}

