/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileNamer;
import se.datadosen.jalbum.FileNamerContext;

public class StandardFileNamer
implements FileNamer {
    private String illegalCharacters = Config.getConfig().getIllegalCharacters() + "\t\n\r";
    private char replacementCharacter = (char)95;

    @Override
    public String createName(AlbumObject ao, FileNamerContext context) {
        return this.makeWebSafe(ao.getName());
    }

    protected String makeWebSafe(String name) {
        char[] nameArray = name.toCharArray();
        for (int i = 0; i < nameArray.length; ++i) {
            if (this.illegalCharacters.indexOf(nameArray[i]) == -1) continue;
            nameArray[i] = this.replacementCharacter;
        }
        return new String(nameArray);
    }

    public char getReplacementCharacter() {
        return this.replacementCharacter;
    }

    public void setReplacementCharacter(char replacementCharacter) {
        this.replacementCharacter = replacementCharacter;
    }
}

