/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Frog;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JErrorFrame;
import se.datadosen.jalbum.LicenseManager;

class SplashScreen
extends JWindow {
    private final int AWARD_YOFFSET = 100;
    private BufferedImage splash;
    private Image background;
    private File customSplash;
    boolean firstPaint;
    private JProgressSpinner spinner;
    private ImageIcon licenseBadge;

    public SplashScreen() {
        super(new Frame());
        this.customSplash = new File(Config.getConfig().progDir, "res/splash.png");
        this.firstPaint = true;
        this.spinner = new JProgressSpinner(34);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.spinner.setSpinning(false);
        }
    }

    private void init() throws Exception {
        LicenseManager mgr = JAlbumContext.getInstance().getLicenseManager();
        String type = mgr.getLicenseType();
        URL url = LicenseManager.class.getResource("/icons/standard/badges/" + type + "-badge.png");
        if (url != null) {
            this.licenseBadge = new ImageIcon(url);
        }
        if (!this.customSplash.exists()) {
            ImageIcon ii = new ImageIcon(this.getClass().getResource("images/splash.png"));
            this.splash = new BufferedImage(ii.getIconWidth(), ii.getIconHeight(), 2);
            Graphics g = this.splash.getGraphics();
            g.drawImage(ii.getImage(), 0, 0, this.splash.getWidth(), this.splash.getHeight(), null);
        }
        this.setSize(this.splash.getWidth(), this.splash.getHeight());
        this.setLocationRelativeTo(null);
        this.setBackground(Color.black);
        if (!this.customSplash.exists()) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isAltDown()) {
                        JAlbum.dumpThreads();
                    } else {
                        Frog dor = new Frog();
                        dor.ribbit();
                    }
                }
            });
        }
        this.add((Component)new JSplashPanel(), "Center");
        this.validate();
    }

    void onError(Throwable t) {
        this.setVisible(false);
        new JErrorFrame(t);
    }

    private class JSplashPanel
    extends JPanel {
        public JSplashPanel() {
            this.init();
        }

        public JSplashPanel(LayoutManager layout) {
            this.init();
        }

        private void init() {
            this.setBackground(Color.black);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
            this.setOpaque(true);
            SplashScreen.this.spinner.setHidden(true);
            SplashScreen.this.spinner.setVisible(false);
            SplashScreen.this.spinner.setForeground(Color.white);
            this.add((Component)SplashScreen.this.spinner, "South");
        }

        @Override
        public void paintComponent(Graphics gg) {
            super.paintComponent(gg);
            Graphics2D g = (Graphics2D)gg;
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            if (SplashScreen.this.background != null) {
                g.drawImage(SplashScreen.this.background, 0, 0, null);
            }
            Composite oldComposite = g.getComposite();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)SplashScreen.this.splash, 0, 0, this);
            g.setComposite(oldComposite);
            if (!SplashScreen.this.customSplash.exists()) {
                if (SplashScreen.this.licenseBadge != null) {
                    g.drawImage(SplashScreen.this.licenseBadge.getImage(), 228, 75, null);
                }
                if (!SplashScreen.this.firstPaint) {
                    g.setFont(new Font("SansSerif", 1, 12));
                    g.setColor(Color.lightGray);
                    String versionText = "38";
                    g.drawString(versionText, 228, 68);
                } else {
                    SplashScreen.this.spinner.setHidden(false);
                    SplashScreen.this.spinner.setVisible(true);
                    SplashScreen.this.firstPaint = false;
                    this.repaint();
                }
            }
        }
    }
}

