/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.inet.jortho.SpellChecker;
import com.inet.jortho.UserDictionaryProvider;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import net.jalbum.util.ExtendedFileUserDictionary;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.URLChecker;

public class SpellCheckerUtils {
    public static String getAvailableDictionaries(File baseDir) {
        StringBuilder buf = new StringBuilder();
        for (File f : baseDir.listFiles()) {
            String name = f.getName();
            if (!name.endsWith(".ortho")) continue;
            int underscoreIndex = name.indexOf(95);
            try {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(name.substring(underscoreIndex + 1, underscoreIndex + 3));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    public static void downloadDictionary(final JCheckBox checkSpelling, final String lang) {
        try {
            final String dictUrlString = JAlbumSite.getInstance().getDictionariesUrl() + "/dictionary_" + lang + ".ortho";
            final File userDictDir = new File(MiniConfig.getMiniConfig().configDir, "dictionaries");
            final JAlbumFrame window = JAlbumContext.getInstance().getFrame();
            if (URLChecker.exists(dictUrlString)) {
                int answer = JOptionPane.showConfirmDialog(checkSpelling, Msg.get("ui.dictionaryForDownload", Locale.getDefault().getDisplayLanguage()), Msg.get("ui.dictionaryMissingTitle"), 0, 3);
                if (answer != 0) {
                    checkSpelling.setSelected(false);
                    return;
                }
                final String statusMessage = Msg.get("ui.downloadingDictionary", Locale.getDefault().getDisplayLanguage());
                window.progressSpinner.workStarted();
                window.statusBar.pushText(statusMessage);
                System.out.println(statusMessage);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        IO.downloadFile(new URL(dictUrlString), userDictDir);
                        SpellCheckerUtils.registerDictionaries();
                        SpellChecker.setCurrentLocale((Locale)new Locale(lang));
                        return null;
                    }

                    @Override
                    protected void done() {
                        window.progressSpinner.workDone();
                        window.statusBar.popText(statusMessage);
                        try {
                            this.get();
                        }
                        catch (ExecutionException ex) {
                            Debug.showErrorDialog(checkSpelling, ex.getCause());
                            checkSpelling.setSelected(false);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }.execute();
            } else {
                JOptionPane.showMessageDialog(checkSpelling, Msg.get("ui.dictionaryMissingError", Locale.getDefault().getDisplayLanguage()), Msg.get("ui.dictionaryMissingTitle"), 0);
                checkSpelling.setSelected(false);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(checkSpelling, Msg.get("ui.dictionaryMissingError", Locale.getDefault().getDisplayLanguage()), Msg.get("ui.dictionaryMissingTitle"), 0);
            checkSpelling.setSelected(false);
        }
    }

    public static boolean isDictionaryPresent() {
        return SpellChecker.getCurrentLocale() != null && SpellChecker.getCurrentLocale().getLanguage().equals(Locale.getDefault().getLanguage());
    }

    public static void registerDictionaries() {
        File dictDir = new File(MiniConfig.getMiniConfig().progDir, "system/dictionaries");
        File userDictDir = new File(MiniConfig.getMiniConfig().configDir, "dictionaries");
        userDictDir.mkdirs();
        SpellChecker.setUserDictionaryProvider((UserDictionaryProvider)new ExtendedFileUserDictionary(userDictDir.getAbsolutePath(), new File(dictDir, "commonWords.txt")));
        Config config = Config.getConfig();
        try {
            SpellChecker.registerDictionaries((URL)dictDir.toURI().toURL(), (String)SpellCheckerUtils.getAvailableDictionaries(dictDir), null);
            SpellChecker.registerDictionaries((URL)userDictDir.toURI().toURL(), (String)SpellCheckerUtils.getAvailableDictionaries(userDictDir), null);
            if (config.isCheckSpelling()) {
                SpellChecker.setCurrentLocale((Locale)new Locale(config.getInterpretedLanguage()));
            }
        }
        catch (IllegalArgumentException ex) {
            config.setCheckSpelling(false);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SpellCheckerUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static void setDefaults() {
        SpellChecker.getOptions().setIgnoreCapitalization(true);
    }
}

