/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Desktop;
import java.awt.Window;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.AppReopenedEvent;
import java.awt.desktop.AppReopenedListener;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.SkinManager;

public class SpecialMacHandler
implements AboutHandler,
OpenFilesHandler,
AppReopenedListener,
PreferencesHandler,
QuitHandler {
    public SpecialMacHandler() {
        SpecialMacHandler.setSystemProperties();
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            desktop.addAppEventListener(this);
            desktop.setAboutHandler(this);
            desktop.setOpenFileHandler(this);
            desktop.setPreferencesHandler(this);
            desktop.setQuitHandler(this);
        }
    }

    private static void setSystemProperties() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "jAlbum");
        System.setProperty("apple.awt.application.name", "jAlbum");
        System.setProperty("apple.awt.antialiasing", "on");
        System.setProperty("apple.awt.interpolation", "bilinear");
        System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        System.setProperty("apple.awt.draggableWindowBackground", "false");
    }

    private void handleFileOpen(final List<File> files) {
        new Thread(this){
            final /* synthetic */ SpecialMacHandler this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.this$0.ensureGuiStarted();
                Object object = JAlbum.initializedOkMonitor;
                synchronized (object) {
                    SwingUtilities.invokeLater(() -> {
                        if (((File)files.get(0)).getName().endsWith(".jaskin")) {
                            new SkinManager().installSkin((File)files.get(0));
                        } else if (((File)files.get(0)).getName().endsWith(".jaext")) {
                            PluginManager.installPlugin((File)files.get(0));
                        } else {
                            JAlbumContext.getInstance().getFrame().addFiles(files);
                        }
                    });
                }
            }
        }.start();
    }

    private void ensureGuiStarted() {
        while (!JAlbum.initialized) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void handleAbout(AboutEvent ae) {
        JAlbum.mainFrame.showAboutBox();
    }

    @Override
    public void openFiles(OpenFilesEvent ofe) {
        this.handleFileOpen(ofe.getFiles());
    }

    @Override
    public void appReopened(AppReopenedEvent arg0) {
        JAlbumFrame f = JAlbum.mainFrame;
        if (f == null) {
            return;
        }
        if (!f.isVisible()) {
            ((Window)f).setVisible(true);
        }
        if (f.getExtendedState() == 1) {
            f.setExtendedState(0);
        }
    }

    @Override
    public void handlePreferences(PreferencesEvent pe) {
        JAlbum.mainFrame.actions.showPreferencesWindowAction.actionPerformed(null);
    }

    @Override
    public void handleQuitRequestWith(QuitEvent qe, QuitResponse qr) {
        if ((JAlbum.mainFrame == null || !JAlbum.mainFrame.isVisible()) && PluginManager.onExit()) {
            System.exit(0);
        }
        if (JAlbum.mainFrame != null) {
            JAlbum.mainFrame.doExit();
        }
    }
}

