/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.VersionNumber;

public class SkinProperties {
    public static final String TITLE = "title";
    public static final String AUTHOR = "author";
    public static final String USERNAME = "username";
    public static final String COMPANY = "company";
    public static final String VERSION = "version";
    public static final String CREATION_DATE = "creationDate";
    public static final String LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String DESCRIPTION = "description";
    public static final String HOME_PAGE = "homePage";
    public static final String SUPPORT_FORUM = "supportForum";
    public static final String REQUIRED_JALBUM_VERSION = "requiredJalbumVersion";
    public static final String AUTO_WIDGET_INJECTION = "autoWidgetInjection";
    public static final String ENABLE_THUMBNAIL_LAYOUT = "enableThumbnailLayout";
    public static final String FULL_SITE_SUPPORT = "fullSiteSupport";
    public static final String PREVENT_COPY = "preventCopy";
    public static final String FULL_VIDEO_SUPPORT = "fullVideoSupport";
    public static final String SCRIPT_LANGUAGE = "scriptLanguage";
    public static final String SKIN_MODEL = "skinModel";
    public static final String SLIDE_MODEL = "slideModel";
    public static final String PRESERVE_VARIABLES = "preserveVariables";
    public static final String SKIN_FAMILY = "skinFamily";
    public static final String MAKE_WEB_LOCATION_SLIDES = "makeWebLocationSlides";
    public static final String THEME_IMAGE_SIZE_NAME = "themeImageSizeName";
    public static final String SEPARATE_THEME_IMAGE = "separateThemeImage";
    public static final String EDITABLE_THEME_IMAGE_SIZE = "editableThemeImageSize";
    public static final String SEPARATE_DESCRIPTION = "separateDescription";
    public static final String MAKE_DEEP_JSON_DATA = "makeDeepJSONData";
    public static final String SUPPORTS_VARIANTS = "supportsVariants";
    public static final String SUPPORTS_FOLDER_THUMBS = "supportsFolderThumbs";
    public static final String DISABLED_CONTROLS = "disabledControls";
    public static final String CLEAN_RES_FOLDER = "cleanResFolder";
    public static final String ICON = "icon";
    public static final String SINGLE_INDEX_PAGE = "singleIndexPage";
    public static final String MAIN_CLASS = "mainClass";
    public static final String SUPPORTS_INTERNAL_LINKING = "supportsInternalLinking";
    private Map<String, String> localProps = new TreeMap<String, String>();
    private RepositoryProperties repositoryProps;
    private File file;

    public SkinProperties(File skinDir) {
        this.file = new File(skinDir, "skin.properties");
        if (this.file.exists()) {
            try {
                this.localProps.putAll(IO.readMapFile(this.file));
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public void save() throws IOException {
        IO.writeMapFile(this.localProps, this.file);
    }

    public String getProperty(String key) {
        return this.localProps.get(key);
    }

    public String getProperty(String key, String def) {
        String value = this.localProps.get(key);
        return value != null ? value : def;
    }

    public Map<String, String> getProperties() {
        return this.localProps;
    }

    public RepositoryProperties getRepositoryProperties() throws IOException {
        if (this.repositoryProps == null) {
            try {
                String skinName = this.file.getParentFile().getName();
                String skinInfoURL = JAlbumSite.getInstance().getSkinInfoUrl();
                if (skinInfoURL == null) {
                    throw new IOException("Can't read skin info url");
                }
                URL u = new URL(IO.combinePaths(skinInfoURL, IO.urlEncode(skinName)));
                Debug.log("Calling URL " + String.valueOf(u));
                URLConnection conn = u.openConnection();
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                try (InputStream is = conn.getInputStream();){
                    InputSource input = new InputSource(is);
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    Node skin = (Node)xpath.evaluate("//skin", input, XPathConstants.NODE);
                    if (skin != null) {
                        boolean usesFlash = false;
                        NodeList features = (NodeList)xpath.evaluate("features/feature", skin, XPathConstants.NODESET);
                        for (int i = 0; i < features.getLength(); ++i) {
                            NamedNodeMap attrs = features.item(i).getAttributes();
                            String name = attrs.getNamedItem("name").getTextContent();
                            if (!"FLASH".equalsIgnoreCase(name)) continue;
                            usesFlash = true;
                        }
                        String version = xpath.evaluate("current-version", skin);
                        String required = xpath.evaluate("jalbum-version", skin);
                        String skinPage = xpath.evaluate("url", skin);
                        String lu = xpath.evaluate("last-updated", skin);
                        GregorianCalendar lastUpdated = new GregorianCalendar();
                        lastUpdated.setTime(DateFormat.getDateInstance(3, new Locale("sv")).parse(lu));
                        VersionNumber requiredVersion = null;
                        if (version != null) {
                            requiredVersion = new VersionNumber(required);
                        }
                        if (version != null) {
                            VersionNumber currentVersion = new VersionNumber(version);
                            this.repositoryProps = new RepositoryProperties(currentVersion, requiredVersion, lastUpdated, skinPage, usesFlash);
                        }
                    }
                }
                if (this.repositoryProps == null) {
                    throw new IOException("Skin not registered with repository");
                }
            }
            catch (MalformedURLException | ParseException | XPathExpressionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.repositoryProps;
    }

    public void setProperty(String key, String value) {
        this.localProps.put(key, value);
    }

    public boolean isAutoWidgetInjection() {
        String s = this.localProps.get(AUTO_WIDGET_INJECTION);
        return !"false".equals(s);
    }

    public boolean isEnableThumbnailLayout() {
        String s = this.localProps.get(ENABLE_THUMBNAIL_LAYOUT);
        return !"false".equals(s);
    }

    public boolean isFullSiteSupport() {
        String s = this.localProps.get(FULL_SITE_SUPPORT);
        return "true".equals(s);
    }

    public boolean isSet(String key) {
        String s = this.localProps.get(key);
        return "true".equals(s);
    }

    public String getThemeImageSizeName() {
        return this.localProps.getOrDefault(THEME_IMAGE_SIZE_NAME, "folderImageSize");
    }

    public boolean isSeparateThemeImage() {
        String s = this.localProps.get(SEPARATE_THEME_IMAGE);
        return "true".equals(s);
    }

    public boolean isEditableThemeImageSize() {
        String s = this.localProps.get(EDITABLE_THEME_IMAGE_SIZE);
        return "true".equals(s);
    }

    public boolean isMakeWebLocationSlides() {
        String s = this.localProps.get(MAKE_WEB_LOCATION_SLIDES);
        return !"false".equals(s);
    }

    public boolean isSeparateDescription() {
        String s = this.localProps.get(SEPARATE_DESCRIPTION);
        return "true".equals(s);
    }

    public boolean isMakeDeepJSONData() {
        String s = this.localProps.get(MAKE_DEEP_JSON_DATA);
        return "true".equals(s);
    }

    public boolean isSupportsVariants() {
        String s = this.localProps.get(SUPPORTS_VARIANTS);
        return "true".equals(s);
    }

    public boolean isSupportsInternalLinking() {
        String s = this.localProps.get(SUPPORTS_INTERNAL_LINKING);
        return "true".equals(s);
    }

    public VersionNumber getVersion() {
        return new VersionNumber(this.getProperty(VERSION, "0"));
    }

    public static class RepositoryProperties {
        private VersionNumber currentVersion;
        private VersionNumber requiredJAlbumVersion;
        private Calendar lastUpdated;
        private String skinPage;
        private boolean usesFlash;

        public RepositoryProperties(VersionNumber currentVersion, VersionNumber requiredJAlbumVersion, Calendar lastUpdated, String skinPage, boolean usesFlash) {
            this.currentVersion = currentVersion;
            this.requiredJAlbumVersion = requiredJAlbumVersion;
            this.lastUpdated = lastUpdated;
            this.skinPage = skinPage;
            this.usesFlash = usesFlash;
        }

        public VersionNumber getCurrentVersion() {
            return this.currentVersion;
        }

        public Calendar getLastUpdated() {
            return this.lastUpdated;
        }

        public String getFormattedLastUpdated() {
            return DateFormat.getDateInstance(1).format(this.lastUpdated.getTime());
        }

        public String getSkinPage() {
            return this.skinPage;
        }

        public boolean isUsesFlash() {
            return this.usesFlash;
        }

        public VersionNumber getRequiredJAlbumVersion() {
            return this.requiredJAlbumVersion;
        }

        public String toString() {
            return "Version:" + String.valueOf(this.currentVersion) + "Required:" + String.valueOf(this.requiredJAlbumVersion) + " Last updated:" + this.getFormattedLastUpdated() + " skinPage: " + this.getSkinPage();
        }
    }
}

