/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.List;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.ChainedObjects;

public class SiblingChainedObjects
extends ChainedObjects {
    public SiblingChainedObjects(AlbumObject root, AlbumBean engine) {
        super(engine);
    }

    private int indexOf(AlbumObject current) {
        int i = 0;
        if (current.getParent() != null) {
            for (AlbumObject ao : current.getParent().getChildren()) {
                if (ao == current) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private AlbumObject getPrevious(AlbumObject parent, int index, boolean folder) {
        List<AlbumObject> children = parent.getChildren();
        while (--index >= 0) {
            AlbumObject ao = children.get(index);
            if (!SiblingChainedObjects.qualifies(ao) || ao.isFolder() != folder) continue;
            return ao;
        }
        if (parent.getParent() != null) {
            List<AlbumObject> siblings = parent.getParent().getChildren();
            for (index = this.indexOf(parent) - 1; index >= 0; --index) {
                AlbumObject sibling = siblings.get(index);
                if (!SiblingChainedObjects.qualifies(sibling) || !sibling.isFolder()) continue;
                return this.getPrevious(sibling, sibling.getChildren().size(), folder);
            }
        }
        return null;
    }

    @Override
    public AlbumObject getPrevious(AlbumObject current, boolean folder) {
        if (current.getParent() == null) {
            return null;
        }
        return this.getPrevious(current.getParent(), this.indexOf(current), folder);
    }

    private AlbumObject getNext(AlbumObject parent, int index, boolean folder) {
        List<AlbumObject> children = parent.getChildren();
        while (++index < children.size()) {
            AlbumObject ao = children.get(index);
            if (!SiblingChainedObjects.qualifies(ao) || ao.isFolder() != folder) continue;
            return ao;
        }
        if (parent.getParent() != null) {
            List<AlbumObject> siblings = parent.getParent().getChildren();
            for (index = this.indexOf(parent) + 1; index < siblings.size(); ++index) {
                AlbumObject sibling = siblings.get(index);
                if (!SiblingChainedObjects.qualifies(sibling) || !sibling.isFolder()) continue;
                return this.getNext(sibling, -1, folder);
            }
        }
        return null;
    }

    @Override
    public AlbumObject getNext(AlbumObject current, boolean folder) {
        if (current.getParent() == null) {
            return null;
        }
        return this.getNext(current.getParent(), this.indexOf(current), folder);
    }

    @Override
    public String getPreviousPath(AlbumObject ao, boolean folder) {
        return this.relativePath(this.getPrevious(ao, folder), ao);
    }

    @Override
    public String getNextPath(AlbumObject ao, boolean folder) {
        return this.relativePath(this.getNext(ao, folder), ao);
    }
}

