/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.nio.file.InvalidPathException;
import se.datadosen.component.windows.jna.Shell32;
import se.datadosen.jalbum.JAlbum;

class Shell32Util
extends com.sun.jna.platform.win32.Shell32Util {
    private static boolean comInitialized;
    private static boolean securityInitialized;

    Shell32Util() {
    }

    public static String getDesktopPath() {
        char[] pszPath = new char[260];
        Shell32.INSTANCE.SHGetSpecialFolderPath(null, pszPath, 0, false);
        return Native.toString((char[])pszPath);
    }

    public static String getMyPicturesPath() {
        char[] pszPath = new char[260];
        Shell32.INSTANCE.SHGetSpecialFolderPath(null, pszPath, 39, false);
        return Native.toString((char[])pszPath);
    }

    public static String getMyMusicPath() {
        char[] pszPath = new char[260];
        Shell32.INSTANCE.SHGetSpecialFolderPath(null, pszPath, 13, false);
        return Native.toString((char[])pszPath);
    }

    public static Pointer SHParseDisplayName(File file) {
        try {
            PointerByReference ppidl = new PointerByReference();
            WinNT.HRESULT hres = Shell32.INSTANCE.SHParseDisplayName(new WString(file.getCanonicalPath()), null, ppidl, new WinDef.ULONG(0L), null);
            if (W32Errors.FAILED((WinNT.HRESULT)hres)) {
                throw new Win32Exception(hres);
            }
            return ppidl.getValue();
        }
        catch (Exception e) {
            throw new InvalidPathException(file.getPath(), e.getMessage());
        }
    }

    public static void SHOpenFolderAndSelectItems(File file) {
        Shell32Util.initCOM();
        Pointer pidlFolder = Shell32Util.SHParseDisplayName(file);
        try {
            WinNT.HRESULT hres = Shell32.INSTANCE.SHOpenFolderAndSelectItems(pidlFolder, new WinDef.UINT(0L), null, new WinDef.DWORD(0L));
            if (W32Errors.FAILED((WinNT.HRESULT)hres)) {
                throw new Win32Exception(hres);
            }
        }
        catch (Exception e) {
            throw new InvalidPathException(file.getPath(), e.getMessage());
        }
        finally {
            Ole32.INSTANCE.CoUninitialize();
        }
    }

    private static boolean initCOM() {
        if (comInitialized) {
            return true;
        }
        WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeEx(null, 0);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            JAlbum.logger.info("COM already initialized.");
            securityInitialized = true;
            return true;
        }
        if (securityInitialized) {
            return true;
        }
        securityInitialized = true;
        return true;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Ole32.INSTANCE.CoUninitialize()));
    }
}

