/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sbbi.upnp.messages.UPNPResponseException;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.event.StatusListener;
import se.datadosen.net.JettyHttpServer;
import se.datadosen.net.NetUtil;
import se.datadosen.net.PortMapping;
import se.datadosen.net.PortMappingListener;
import se.datadosen.net.Share;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.XMLDocument;
import se.datadosen.util.BeanBinder;

public class ShareBean
extends JettyHttpServer
implements PortMappingListener {
    public static final String NO_LOGGING = "no";
    public static final String CONSOLE_LOGGING = "console";
    public static final String FILE_LOGGING = "file";
    static final File settingsFile = Config.getConfigFile("shares.xml", ".jalbum-sharing.xml");
    private PortMapping portMapping = null;
    private transient Vector statusListeners;
    private String externalAddress;
    private String hostName = "localhost";
    private boolean autoStart;
    private boolean doPortMapping = true;
    private String logType = "no";
    private String logFileName = "albumsharing.log";
    private String formatString = "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"";
    private CustomRequestLog logger = new CustomRequestLog((RequestLog.Writer)new RequestLogWriter(), this.formatString);
    boolean loopbackAccessOk = false;
    boolean accessViaProxyOk = false;

    public ShareBean() {
        this.setPort(NetUtil.getFreeServerPort());
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public String getLogFormatString() {
        return this.logger.getFormatString();
    }

    public void setLogFormatString(String formatString) {
        this.formatString = formatString;
    }

    public void updateLogger() {
        if (this.logType.equals(NO_LOGGING)) {
            this.server.setRequestLog(null);
            return;
        }
        this.logger = this.logType.equals(CONSOLE_LOGGING) ? new CustomRequestLog(s -> System.out.println(s), this.formatString) : new CustomRequestLog((RequestLog.Writer)new RequestLogWriter(this.logFileName), this.formatString);
        this.server.setRequestLog((RequestLog)this.logger);
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isDoPortMapping() {
        return this.doPortMapping;
    }

    public void setDoPortMapping(boolean doPortMapping) {
        this.doPortMapping = doPortMapping;
    }

    @Override
    public void start() throws Exception {
        this.updateLogger();
        super.start();
        this.fireStatusChanged("Web server started");
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.fireStatusChanged("Web server stopped");
    }

    public void ensurePortMapping() throws UPNPResponseException, IOException {
        if (this.portMapping != null) {
            if (this.portMapping.getPort() != this.getPort()) {
                this.portMapping.setMapping(this.getPort());
            }
        } else if (InetAddress.getLocalHost().isSiteLocalAddress()) {
            this.portMapping = new PortMapping("JAlbum album sharing", this.getPort(), this);
        }
    }

    private String getExternalAddressFromWeb() throws IOException {
        URL url = new URL("http://checkip.dyndns.org");
        Object o = url.getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)o));
        String s = reader.readLine();
        return s.substring(s.indexOf(58) + 1, s.indexOf("</body>")).trim();
    }

    public String getExternalAddress() throws UPNPResponseException, IOException {
        if (this.externalAddress == null) {
            this.externalAddress = this.portMapping != null ? this.portMapping.getExternalAddress() : (InetAddress.getLocalHost().isSiteLocalAddress() ? this.getExternalAddressFromWeb() : InetAddress.getLocalHost().getHostAddress());
        }
        return this.externalAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean albumAccessTest() {
        try {
            this.accessViaProxyOk = true;
            String url1 = "http://" + this.getExternalAddress() + ":" + this.getPort() + "/PingServlet";
            this.loopbackAccessOk = this.albumAccessTest(new URL(url1), 700);
            if (!this.loopbackAccessOk) {
                String url2 = "http://jalbum.net/servlet/ProxyServlet?url=http://" + this.getExternalAddress() + ":" + this.getPort() + "/PingServlet";
                this.accessViaProxyOk = this.albumAccessTest(new URL(url2), 2000);
                return this.accessViaProxyOk;
            }
            return true;
        }
        catch (IOException | UPNPResponseException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean albumAccessTest(URL url, int timeout) {
        try {
            try (Socket sock = new Socket();){
                int port = url.getPort();
                if (port == -1) {
                    port = 80;
                }
                sock.connect(new InetSocketAddress(url.getHost(), port), timeout);
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            Object o = conn.getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)o));
            String s = reader.readLine();
            return s.equals("jAlbum album sharing");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void saveSettings() throws IOException {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(settingsFile)));){
            Element sharing = new Element("sharing");
            sharing.setAttribute("port", this.getPort());
            sharing.setAttribute("hostName", this.hostName);
            sharing.setAttribute("autoStart", this.autoStart);
            sharing.setAttribute("doPortMapping", this.doPortMapping);
            sharing.setAttribute("logType", this.logType);
            sharing.setAttribute("logFileName", this.logFileName);
            for (Share share : this.getShares()) {
                Element el = new Element("share");
                el.setAttribute("uri", share.uri);
                el.setAttribute("localPath", share.localPath);
                el.setAttribute("active", share.active);
                el.setAttribute("passwordProtect", share.passwordProtect);
                el.setAttribute("userName", share.userName);
                el.setAttribute("password", share.password);
                sharing.addContentElement(el);
            }
            XMLDocument doc = new XMLDocument(sharing);
            out.print(doc.serialize());
        }
    }

    public void loadSettings() throws IOException, ElementException {
        try {
            TreeSet<Share> shares = new TreeSet<Share>();
            if (!settingsFile.exists()) {
                return;
            }
            try (FileInputStream is = new FileInputStream(settingsFile);){
                InputSource input = new InputSource(is);
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node sharingNode = (Node)xpath.evaluate("/sharing", input, XPathConstants.NODE);
                if (sharingNode != null) {
                    HashMap<String, String> attrs = new HashMap<String, String>();
                    NamedNodeMap nnm = sharingNode.getAttributes();
                    for (int i = 0; i < nnm.getLength(); ++i) {
                        Node n = nnm.item(i);
                        attrs.put(n.getNodeName(), n.getNodeValue());
                    }
                    BeanBinder.setProperties(this, attrs);
                    NodeList shareNodes = (NodeList)xpath.evaluate("//share", sharingNode, XPathConstants.NODESET);
                    for (int i = 0; i < shareNodes.getLength(); ++i) {
                        Node sn = shareNodes.item(i);
                        Share share = new Share((String)xpath.evaluate("@localPath", sn, XPathConstants.STRING), (String)xpath.evaluate("@uri", sn, XPathConstants.STRING), "true".equals(xpath.evaluate("@active", sn, XPathConstants.STRING)));
                        share.passwordProtect = "true".equals(xpath.evaluate("@passwordProtect", sn, XPathConstants.STRING));
                        share.userName = (String)xpath.evaluate("@userName", sn, XPathConstants.STRING);
                        share.password = (String)xpath.evaluate("@password", sn, XPathConstants.STRING);
                        shares.add(share);
                    }
                    this.setShares(shares);
                }
            }
        }
        catch (XPathExpressionException ex) {
            throw new IOException(ex);
        }
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    protected void fireStatusChanged(String msg) {
        if (this.statusListeners != null) {
            Vector listeners = this.statusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((StatusListener)listeners.elementAt(i)).statusChanged(msg);
            }
        }
    }

    @Override
    public void statusChanged(String msg) {
        this.fireStatusChanged(msg);
    }
}

