/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jalbum.remotefs.RemoteFS;
import net.jalbum.remotefs.RemoteFSBean;
import net.jalbum.remotefs.RemoteFSDelegate;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFSProgressMonitor;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.util.NamedThreadFactory;

class RemoteFSWorkers<T, R>
implements AutoCloseable {
    private final GenericObjectPool<Connection> pool;
    private ExecutorService workers = this.createWorkers();
    private List<Future<R>> results = new ArrayList<Future<R>>();
    private Throwable throwable;
    private RemoteFSProgressMonitor monitor;
    Set<Connection> activeConnections = new HashSet<Connection>();

    public RemoteFSWorkers(final UploadBean uploadBean, int maxConn) {
        this.pool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<Connection>(this){
            private final AtomicBoolean firstRun = new AtomicBoolean(true);
            private int connectionNumber;
            final /* synthetic */ RemoteFSWorkers this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void activateObject(PooledObject<Connection> p) throws Exception {
                Set<Connection> set = this.this$0.activeConnections;
                synchronized (set) {
                    this.this$0.activeConnections.add((Connection)p.getObject());
                    ((Connection)p.getObject()).bytesInTransfer = 0L;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void passivateObject(PooledObject<Connection> p) throws Exception {
                Set<Connection> set = this.this$0.activeConnections;
                synchronized (set) {
                    this.this$0.activeConnections.remove(p.getObject());
                }
            }

            public void destroyObject(PooledObject<Connection> p) throws Exception {
                this.status("destroy");
                if (((Connection)p.getObject()).remoteFS != uploadBean.getRemoteFS()) {
                    JAlbum.logger.fine("Disconnecting");
                    ((Connection)p.getObject()).remoteFS.disconnect();
                }
            }

            public boolean validateObject(PooledObject<Connection> p) {
                this.status("validate");
                try {
                    return ((Connection)p.getObject()).remoteFS.isConnected();
                }
                catch (RemoteFSException ex) {
                    return false;
                }
            }

            public Connection create() throws Exception {
                this.status("create");
                if (this.firstRun.getAndSet(false)) {
                    return this.this$0.new Connection(uploadBean.getRemoteFS(), this.connectionNumber++);
                }
                JAlbum.logger.fine("Connecting");
                RemoteFSDelegate remoteFS = RemoteFSBean.createInstance();
                remoteFS.setProtocol(uploadBean.getProtocol());
                remoteFS.setForceUTF8(uploadBean.isFtpForceUTF8());
                remoteFS.setPassiveMode(uploadBean.isPassiveMode());
                remoteFS.setPort(uploadBean.getFtpPort());
                remoteFS.setTrackDiskSpaceUsage(uploadBean.isMyjalbum());
                remoteFS.connect(uploadBean.getFtpServer(), uploadBean.getFtpUser(), uploadBean.getFtpPassword());
                return this.this$0.new Connection(remoteFS, this.connectionNumber++);
            }

            public PooledObject<Connection> wrap(Connection obj) {
                return new DefaultPooledObject((Object)obj);
            }

            public String getPoolStatus() {
                return " active: " + this.this$0.pool.getNumActive() + " idle: " + this.this$0.pool.getNumIdle() + " waiters: " + this.this$0.pool.getNumWaiters();
            }

            private void status(String event) {
            }
        });
        this.pool.setMaxTotal(maxConn);
        this.pool.setLifo(false);
    }

    public R executeNow(RemoteWork<T, R> rm) throws RemoteFSException, IOException {
        try {
            return new RemoteCallable<T, R>(rm).call();
        }
        catch (IOException | RemoteFSException | OperationAbortedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Future<R> submit(RemoteWork<T, R> rm) throws RemoteFSException, IOException {
        this.checkThrowable();
        try {
            Future future = this.workers.submit(new RemoteCallable<T, R>(rm));
            this.results.add(future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new OperationAbortedException();
        }
    }

    public Future<R> submit(T object, final RemoteProcessor processor) throws RemoteFSException, IOException {
        return this.submit(new RemoteWork<T, R>(this, object){
            final /* synthetic */ RemoteFSWorkers this$0;
            {
                this.this$0 = this$0;
                super(object);
            }

            @Override
            public R call(T object, RemoteFS remoteFS) throws IOException, RemoteFSException, OperationAbortedException {
                processor.process(remoteFS);
                return null;
            }
        });
    }

    public R executeNow(T object, final RemoteProcessor processor) throws RemoteFSException, IOException {
        return this.executeNow(new RemoteWork<T, R>(this, object){
            final /* synthetic */ RemoteFSWorkers this$0;
            {
                this.this$0 = this$0;
                super(object);
            }

            @Override
            public R call(T object, RemoteFS remoteFS) throws IOException, RemoteFSException, OperationAbortedException {
                processor.process(remoteFS);
                return null;
            }
        });
    }

    public void awaitCompletion() throws RemoteFSException, IOException {
        this.checkThrowable();
        try {
            for (Future<R> result : this.results) {
                result.get();
            }
        }
        catch (InterruptedException ex) {
            throw new OperationAbortedException();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof OperationAbortedException) {
                throw (OperationAbortedException)ex.getCause();
            }
            if (ex.getCause() instanceof InterruptedException) {
                throw new OperationAbortedException();
            }
            if (ex.getCause() instanceof RemoteFSException) {
                throw (RemoteFSException)ex.getCause();
            }
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            if (ex.getCause() instanceof IllegalStateException) {
                throw new OperationAbortedException();
            }
            throw new RuntimeException(ex.getCause());
        }
        finally {
            this.results.clear();
        }
    }

    public void abortWorkers() {
        if (!this.workers.isShutdown()) {
            try {
                this.workers.shutdownNow();
                this.workers.awaitTermination(10L, TimeUnit.SECONDS);
                System.out.println("Aborted. All workers shut down");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void initWorkers() {
        this.abortWorkers();
        this.workers = this.createWorkers();
    }

    public boolean isShutdown() {
        return this.pool.isClosed();
    }

    public void shutdown() {
        if (!this.pool.isClosed()) {
            this.pool.close();
        }
        if (!this.workers.isShutdown()) {
            try {
                this.workers.shutdownNow();
                this.workers.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("All workers shut down");
        }
    }

    public void setProgressMonitor(RemoteFSProgressMonitor monitor) {
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesInTransfer() {
        Set<Connection> set = this.activeConnections;
        synchronized (set) {
            return this.activeConnections.stream().mapToLong(conn -> conn.bytesInTransfer).sum();
        }
    }

    public int getCurrentConnectionCount() {
        return this.pool.getNumActive() + this.pool.getNumIdle();
    }

    private void checkThrowable() throws IOException, RemoteFSException, OperationAbortedException {
        if (this.throwable != null) {
            try {
                throw this.throwable;
            }
            catch (IOException | RuntimeException | RemoteFSException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private ExecutorService createWorkers() {
        return Executors.newFixedThreadPool(16, new NamedThreadFactory("RemoteFSWorker"));
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private class RemoteCallable<T, R>
    implements Callable<R> {
        private RemoteWork<T, R> work;

        public RemoteCallable(RemoteWork<T, R> work) {
            this.work = work;
        }

        /*
         * Exception decompiling
         */
        @Override
        public R call() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static abstract class RemoteWork<T, R> {
        private T object;

        public RemoteWork(T object) {
            this.object = object;
        }

        public abstract R call(T var1, RemoteFS var2) throws IOException, RemoteFSException, OperationAbortedException;

        public String toString() {
            return this.object.toString();
        }
    }

    @FunctionalInterface
    public static interface RemoteProcessor {
        public void process(RemoteFS var1) throws IOException, RemoteFSException, OperationAbortedException;
    }

    private class Connection
    implements RemoteFSProgressMonitor {
        RemoteFS remoteFS;
        long bytesInTransfer;
        private int connectionNumber;

        public Connection(RemoteFS remoteFS, int connectionNumber) {
            this.remoteFS = remoteFS;
            this.connectionNumber = connectionNumber;
            remoteFS.setProgressMonitor(this);
        }

        @Override
        public void bytesTransferred(long count) {
            this.bytesInTransfer = count;
            if (RemoteFSWorkers.this.monitor != null) {
                RemoteFSWorkers.this.monitor.bytesTransferred(RemoteFSWorkers.this.getBytesInTransfer());
            }
        }

        public int getConnectionNumber() {
            return this.connectionNumber;
        }

        public String toString() {
            return "" + this.connectionNumber;
        }
    }
}

