/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.RemoteFSNode;
import se.datadosen.util.DataSizeFormatter;

public class RemoteFSTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Component comp = new JPanel();
    private Icon serverIcon = Icons.small("server");
    private Icon earthIcon = Icons.get("earth_mini", 10);
    private Icon linkIcon = Icons.tiny("link-windows");
    private Icon lockIcon = Icons.get("lock_mini", 14);
    private Icon albumIcon = Icons.small("book");
    private Icon nodeIcon = Icons.get("empty", 14);
    private Icon folderIcon = Icons.get("folder-closed", 14);
    TreeNode webRootNode;
    private Icon rootIcon;
    private static final int ICON_SIZE = 18;

    public RemoteFSTreeCellRenderer() {
        this.setRootIcon(this.serverIcon);
    }

    public void setWebRoot(TreeNode webRootNode) {
        this.webRootNode = webRootNode;
    }

    public TreeNode getWebRoot() {
        return this.webRootNode;
    }

    public void setRootIcon(Icon rootIcon) {
        this.rootIcon = rootIcon;
    }

    public Icon getRootIcon() {
        return this.rootIcon;
    }

    private ImageIcon addEarthIcon(Icon bgIcon) {
        BufferedImage bi = new BufferedImage(Math.max(bgIcon.getIconWidth(), 18), Math.max(bgIcon.getIconHeight(), 18), 6);
        Graphics g = bi.getGraphics();
        bgIcon.paintIcon(this.comp, g, 0, 0);
        this.earthIcon.paintIcon(this.comp, g, 7, 7);
        g.dispose();
        return new ImageIcon(bi);
    }

    private ImageIcon addLinkIcon(Icon bgIcon) {
        BufferedImage bi = new BufferedImage(bgIcon.getIconWidth(), bgIcon.getIconHeight() < 16 ? 16 : bgIcon.getIconHeight(), 6);
        Graphics g = bi.getGraphics();
        bgIcon.paintIcon(this.comp, g, 0, 0);
        this.linkIcon.paintIcon(this.comp, g, 0, 7);
        g.dispose();
        return new ImageIcon(bi);
    }

    private ImageIcon addLockIcon(Icon bgIcon) {
        BufferedImage bi = new BufferedImage(bgIcon.getIconWidth(), bgIcon.getIconHeight() < 16 ? 16 : bgIcon.getIconHeight(), 6);
        Graphics g = bi.getGraphics();
        bgIcon.paintIcon(this.comp, g, 0, 0);
        this.lockIcon.paintIcon(this.comp, g, 3, 1);
        g.dispose();
        return new ImageIcon(bi);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        RemoteFSNode node = (RemoteFSNode)value;
        if (node.areChildrenDefined()) {
            this.setToolTipText(node.getPlainFileCount() + " files. " + (node.getChildCount() - node.getPlainFileCount()) + " directories");
        } else if (node.isLeaf()) {
            this.setToolTipText(node.getSize() + " bytes (" + String.valueOf(DataSizeFormatter.formatBytes(node.getSize())) + ")");
        } else {
            this.setToolTipText(null);
        }
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            if (node.isRoot()) {
                this.setDisabledIcon(this.getRootIcon());
            } else if (node.isAlbum()) {
                this.setDisabledIcon(this.albumIcon);
            } else if (leaf) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
            if (node.isLink()) {
                this.setDisabledIcon(this.addLinkIcon(this.getDisabledIcon()));
            }
            if (node.isPasswordProtected()) {
                this.setDisabledIcon(this.addLockIcon(this.getDisabledIcon()));
            }
            if (node == this.webRootNode) {
                this.setDisabledIcon(this.addEarthIcon(this.getDisabledIcon()));
            }
        } else {
            this.setEnabled(true);
            if (node.isRoot()) {
                this.setIcon(this.getRootIcon());
            } else if (node.isAlbum()) {
                this.setIcon(this.albumIcon);
            } else if (leaf) {
                this.setIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
            if (this.getIcon() == null) {
                this.setIcon(leaf ? this.nodeIcon : this.folderIcon);
            }
            if (node.isLink()) {
                this.setIcon(this.addLinkIcon(this.getIcon()));
            }
            if (node.isPasswordProtected()) {
                this.setIcon(this.addLockIcon(this.getIcon()));
            }
            if (node == this.webRootNode) {
                this.setIcon(this.addEarthIcon(this.getIcon()));
            }
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }
}

