/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jalbum.Rendition;
import net.jalbum.util.Profiler;
import net.jalbum.util.Work;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.IncludeOption;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.ProjectSettings;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.util.IO;
import se.datadosen.util.StringUtil;

public class RecoveryTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeZipEntry(String path, InputStream in, ZipOutputStream out) throws IOException {
        byte[] data;
        ZipEntry ze = new ZipEntry(path);
        try {
            data = in.readAllBytes();
        }
        finally {
            in.close();
        }
        ZipOutputStream zipOutputStream = out;
        synchronized (zipOutputStream) {
            out.putNextEntry(ze);
            out.write(data);
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLifeboat(JAlbumContext context, AlbumBean engine, AlbumObject root, OutputStream out) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(-1);
        try (AutoCloseable _s = Profiler.profile();){
            ProjectSettings settings = new ProjectSettings(engine);
            settings.main.put("ignoreDirectory", "true");
            RecoveryTool.writeZipEntry("jalbum-settings.jap", settings.getInputStream(), zout);
            Consumer<AlbumObject> handler = ao -> {
                block13: {
                    try {
                        String pathFromRoot = ao.getPathFromRoot();
                        if (ao.isFolder()) {
                            File jalbumDir = new File(ao.getFile(), ".jalbum");
                            if (!"".equals(pathFromRoot)) {
                                ZipEntry e = new ZipEntry(pathFromRoot + "/");
                                ZipOutputStream zipOutputStream = zout;
                                synchronized (zipOutputStream) {
                                    zout.putNextEntry(e);
                                }
                            }
                            if (!jalbumDir.exists()) break block13;
                            String jalbumPath = IO.combinePaths(pathFromRoot, ".jalbum");
                            ZipEntry e = new ZipEntry(jalbumPath + "/");
                            ZipOutputStream zipOutputStream = zout;
                            synchronized (zipOutputStream) {
                                zout.putNextEntry(e);
                            }
                            CachedFile[] contents = CachedFile.listFiles(jalbumDir);
                            if (contents != null) {
                                for (CachedFile f : contents) {
                                    if (((File)f).isDirectory()) continue;
                                    RecoveryTool.writeZipEntry(IO.combinePaths(jalbumPath, f.getName()), new FileInputStream(f), zout);
                                }
                            }
                            break block13;
                        }
                        if (ao.getCategory() == Category.webPage && !(ao.getFile() instanceof LinkFile)) {
                            RecoveryTool.writeZipEntry(IO.combinePaths(pathFromRoot, ao.getName()), new FileInputStream(ao.getFile()), zout);
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            handler.accept(root);
            new TreeCollection(root, EnumSet.of(IncludeOption.EXCLUDED, IncludeOption.HIDDEN)).ordered(false).parallelStream().forEach(handler);
        }
        catch (RuntimeException ex) {
            Throwable cause = ex;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw ex;
        }
        finally {
            ZipOutputStream zipOutputStream = zout;
            synchronized (zipOutputStream) {
                zout.finish();
                zout.close();
            }
        }
    }

    public static void recreateProjectFromAlbum(File albumDir, File projectDir) throws FileNotFoundException, IOException {
        File lifeboatFile = new File(albumDir, "lifeboat.zip");
        try {
            IO.unzip(lifeboatFile, projectDir);
            System.out.println("Project settings found and imported");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        RecoveryTool.copyImages(albumDir, projectDir);
        System.out.println("Images copied from " + String.valueOf(albumDir) + " to " + String.valueOf(projectDir));
        File projectFile = RecoveryTool.findProjectFile(projectDir);
        if (projectFile != null) {
            Properties props = IO.readPropertyFile(projectFile);
            props.remove("directory");
            try (FileOutputStream fos = new FileOutputStream(projectFile);){
                props.store(fos, "jAlbum Project");
            }
        } else {
            projectFile = new File(projectDir, "jalbum-settings.jap");
            projectFile.createNewFile();
        }
        JAlbumContext.getInstance().getFrame().loadProject(projectFile);
        AlbumObject rootFolder = JAlbumContext.getInstance().getExplorer().getRootFolder();
        Work.on(rootFolder.getDescendants()).forEach(ao -> {
            if (ao.getCategory() == Category.video) {
                ao.setIncludeOriginal(true);
            }
        });
        RecoveryTool.importJSON(albumDir, JAlbumContext.getInstance().getFrame().albumExplorer.getRootFolder());
    }

    static File getPrimaryFile(File dir, String baseName) {
        ArrayList<File> candidates = new ArrayList<File>();
        if (!dir.exists()) {
            return null;
        }
        for (File f : dir.listFiles()) {
            if (!baseName.equals(Rendition.nameRoot(f.getName())) || f.getName().endsWith(".html")) continue;
            candidates.add(f);
        }
        Collections.sort(candidates, (f1, f2) -> (int)(f2.length() - f1.length()));
        if (!candidates.isEmpty()) {
            return (File)candidates.get(0);
        }
        return null;
    }

    private static void copyImages(File fromDir, File toDir) throws IOException {
        boolean dirMade = false;
        File[] thumbFiles = new File(fromDir, "thumbs").listFiles(f -> !f.isDirectory() && !f.getName().startsWith("."));
        if (thumbFiles != null) {
            for (File file : thumbFiles) {
                if (!dirMade) {
                    toDir.mkdirs();
                    dirMade = true;
                }
                if (!Rendition.isTypical(file.getName())) continue;
                File file2 = RecoveryTool.getPrimaryFile(new File(fromDir, "slides"), IO.baseName(file.getName()));
                if (file2 != null) {
                    IO.copyFile(file2, new File(toDir, IO.baseName(file) + "." + IO.extensionOf(file2)));
                }
                if ((file2 = new File(fromDir, "hi-res/" + file.getName())).exists()) {
                    IO.copyFile(file2, toDir);
                }
                if (!(file2 = RecoveryTool.originalFile(fromDir, file.getName())).exists()) continue;
                IO.copyFile(file2, toDir);
            }
        }
        for (File file : CachedFile.listFiles(fromDir)) {
            if (!file.isDirectory()) continue;
            RecoveryTool.copyImages(file, new File(toDir, file.getName()));
        }
    }

    private static File originalFile(File fromDir, String name) {
        String baseName = IO.baseName(name);
        for (File f : fromDir.listFiles()) {
            if (!f.getName().startsWith(baseName)) continue;
            return f;
        }
        return new File(fromDir, name);
    }

    private static File findProjectFile(File dir) {
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith(".jap")) continue;
            return f;
        }
        return null;
    }

    private static void importJSON(File albumFolder, AlbumObject dest) {
        try {
            JsonObject rootObject;
            File dataFile = new File(albumFolder, "data1.json");
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(dataFile), "UTF-8");){
                rootObject = (JsonObject)Jsoner.deserialize((Reader)reader);
            }
            String description = (String)rootObject.get((Object)"comment");
            if (description != null) {
                dest.setComment(description);
            }
            JsonArray folders = (JsonArray)rootObject.get((Object)"objects");
            for (Object ch : folders) {
                String thumbPath;
                JsonArray keywords;
                String title;
                JsonObject child = (JsonObject)ch;
                AlbumObject matchingChild = dest.getChild((String)child.get((Object)"name"));
                if (matchingChild == null) continue;
                String comment = (String)child.get((Object)"comment");
                if (comment != null) {
                    matchingChild.setComment(comment);
                    System.out.println("Setting comment for " + String.valueOf(matchingChild));
                }
                if ((title = (String)child.get((Object)"title")) != null) {
                    matchingChild.setTitle(title);
                    System.out.println("Setting title for " + String.valueOf(matchingChild));
                }
                if ((keywords = (JsonArray)child.get((Object)"keywords")) != null) {
                    matchingChild.setKeywords(StringUtil.setToString(new TreeSet(keywords)));
                    System.out.println("Setting keywords for " + String.valueOf(matchingChild));
                }
                if (!"folder".equals(child.get((Object)"category")) || (thumbPath = (String)((JsonObject)child.get((Object)"thumb")).get((Object)"path")) == null) continue;
                thumbPath = URLDecoder.decode(thumbPath, "UTF-8");
                AlbumObject rep = dest.getChild(thumbPath = thumbPath.replace("/thumbs/", "/"));
                if (rep == null) continue;
                matchingChild.setRepresentingAlbumObject(rep);
                System.out.println("Setting " + String.valueOf(rep) + " to represent folder " + String.valueOf(matchingChild));
            }
        }
        catch (JsonException | IOException ex) {
            System.err.println("Error parsing " + String.valueOf(new File(albumFolder, "data1.json")) + ": " + String.valueOf(ex));
        }
        for (AlbumObject child : dest.getChildren(Category.folder)) {
            RecoveryTool.importJSON(new File(albumFolder, child.getName()), child);
        }
    }
}

