/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.util.IO;

public class RecentProjectFiles {
    private static RecentProjectFiles theInstance;
    private File storeFile;
    private ArrayList<File> files;
    private transient ArrayList<Listener> listeners;
    private int loadedHashCode;

    public static RecentProjectFiles getInstance() {
        if (theInstance == null) {
            theInstance = new RecentProjectFiles(RecentProjectFiles.convertConfigFile("recent-projects.txt", ".jalbum-recent-projects.properties"));
        }
        return theInstance;
    }

    private RecentProjectFiles(File storeFile) {
        this.storeFile = storeFile;
        this.init();
    }

    private int getMaxFiles() {
        int maxFiles = Config.getConfig().getRecentProjects();
        return maxFiles == 0 ? Integer.MAX_VALUE : maxFiles;
    }

    private static File convertConfigFile(String newName, String oldName) {
        File oldFile = new File(System.getProperty("user.home"), oldName);
        File newFile = new File(MiniConfig.getMiniConfig().configDir, newName);
        MiniConfig.getMiniConfig().configDir.mkdir();
        if (!newFile.exists() && oldFile.exists()) {
            try {
                String name;
                ArrayList<File> files = new ArrayList<File>();
                Properties props = new Properties();
                try (FileInputStream fis = new FileInputStream(oldFile);){
                    props.load(fis);
                }
                int i = 1;
                while ((name = props.getProperty("File" + i)) != null) {
                    files.add(new File(name));
                    ++i;
                }
                RecentProjectFiles.save(files, newFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return newFile;
    }

    public List<File> getFiles() {
        return this.files;
    }

    private void init() {
        this.files = new ArrayList();
        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.storeFile), "UTF-8"));){
            String line;
            while ((line = reader2.readLine()) != null) {
                this.files.add(new File(line));
            }
            this.loadedHashCode = this.files.hashCode();
        }
        catch (FileNotFoundException reader2) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RecentProjectFiles.this.save();
            }
        });
    }

    public void replaceFile(File oldFile, File newFile) {
        for (int i = 0; i < this.files.size(); ++i) {
            File f = this.files.get(i);
            if (!f.equals(oldFile)) continue;
            this.files.set(i, newFile);
            break;
        }
        this.fireProjectFileRenamed(oldFile, newFile);
        this.save();
    }

    public boolean save() {
        if (this.files.hashCode() == this.loadedHashCode) {
            return false;
        }
        if (this.files.isEmpty() && this.loadedHashCode == 0) {
            return false;
        }
        RecentProjectFiles.save(this.files, this.storeFile);
        return true;
    }

    private static void save(ArrayList<File> files, File dest) {
        if (files.isEmpty()) {
            return;
        }
        File tmp = new File(dest.getParentFile(), dest.getName() + ".tmp");
        StringBuilder buf = new StringBuilder();
        try {
            for (File f : files) {
                buf.append(f.getAbsolutePath());
                buf.append("\r\n");
            }
            IO.writeTextFile(buf.toString(), tmp, "UTF-8");
            if (tmp.length() > 10L) {
                dest.delete();
                tmp.renameTo(dest);
            } else {
                tmp.delete();
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    public void addFile(File file) {
        File removed;
        if (this.files.remove(file)) {
            this.fireRemoved(file);
        }
        this.files.add(0, file);
        this.fireAdded(file);
        if (this.files.size() > this.getMaxFiles() && (removed = this.files.remove(this.files.size() - 1)) != null) {
            this.fireRemoved(removed);
        }
    }

    public void removeFile(File file) {
        if (this.files.remove(file)) {
            this.fireRemoved(file);
        }
    }

    public void clear() {
        this.files.clear();
        this.storeFile.delete();
        this.fireStructureChanged();
    }

    public synchronized void removeListener(Listener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            ArrayList<Listener> list = new ArrayList<Listener>(this.listeners);
            list.remove(l);
            this.listeners = list;
        }
    }

    public synchronized void addListener(Listener l) {
        ArrayList<Listener> list;
        ArrayList<Listener> arrayList = list = this.listeners == null ? new ArrayList<Listener>(2) : new ArrayList<Listener>(this.listeners);
        if (!list.contains(l)) {
            list.add(l);
            this.listeners = list;
        }
    }

    protected void fireAdded(File f) {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.projectFileAdded(this, f);
            }
        }
    }

    protected void fireRemoved(File f) {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.projectFileRemoved(this, f);
            }
        }
    }

    protected void fireStructureChanged() {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.structureChanged(this);
            }
        }
    }

    protected void fireProjectFileRenamed(File oldName, File newName) {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.projectFileRenamed(this, oldName, newName);
            }
        }
    }

    public static interface Listener {
        public void projectFileRenamed(RecentProjectFiles var1, File var2, File var3);

        public void structureChanged(RecentProjectFiles var1);

        default public void projectFileAdded(RecentProjectFiles list, File name) {
            this.structureChanged(list);
        }

        default public void projectFileRemoved(RecentProjectFiles list, File name) {
            this.structureChanged(list);
        }
    }
}

