/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.PrintSafeHashMap;

public class ProjectSettings {
    public Properties main = new Properties();
    public Map<String, Object> skin = new PrintSafeHashMap();
    public Map<String, String> user = new PrintSafeHashMap();
    private static final Set<String> ignoreKeys = new HashSet<String>();
    static final Set<String> SPECIFIC_KEYS = new HashSet<String>();
    private boolean firstLog = true;

    public ProjectSettings() {
    }

    public ProjectSettings(AlbumBean engine) {
        this();
        try {
            this.main = BeanBinder.getProperties(engine);
            this.main.remove("userVariables");
            this.main.remove("skinVariables");
            this.skin.putAll(engine.getSkinVariables());
            this.user.putAll(engine.getUserVariables());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String filterKey(int i) {
        return "filter" + i;
    }

    public ProjectSettings imageRelated() {
        ProjectSettings ir = new ProjectSettings();
        this.copyProps(this.main, ir.main, "imageSize", "thumbSize", "folderThumbSize", "scalingMethod", "sharpenPercent", "qualityPercent", "highQualityThumbs", "keepMetaData", "hiDPIImages", "hiDPIThumbs", "qualityPercentWebP", "smoothScalingType", "creator", "rights", "rightsURL", "thumbVariants", "imageVariants");
        int i = 1;
        while (this.user.get(ProjectSettings.filterKey(i)) != null) {
            ir.user.put(ProjectSettings.filterKey(i), this.user.get(ProjectSettings.filterKey(i)));
            ++i;
        }
        return ir;
    }

    public boolean unionEquals(ProjectSettings other) {
        this.firstLog = true;
        boolean equals = true;
        if (!this.user.equals(other.user)) {
            equals = false;
            if (Config.getConfig().isDebugMode()) {
                System.out.println("User variable difference detected:");
                System.out.println(String.valueOf(this.user) + "\n vs\n" + String.valueOf(other.user));
            } else {
                return false;
            }
        }
        for (Map.Entry<Object, Object> entry : this.main.entrySet()) {
            if (ignoreKeys.contains(entry.getKey()) || !other.main.containsKey(entry.getKey()) || entry.getValue().equals(other.main.get(entry.getKey()))) continue;
            equals = false;
            if (Config.getConfig().isDebugMode()) {
                this.log("main", entry, other.main.get(entry.getKey()));
                continue;
            }
            return false;
        }
        for (Map.Entry<Object, Object> entry : this.skin.entrySet()) {
            if (!other.skin.containsKey(entry.getKey()) || entry.getValue().equals(other.skin.get(entry.getKey()))) continue;
            equals = false;
            if (Config.getConfig().isDebugMode()) {
                this.log("skin", entry, other.skin.get(entry.getKey()));
                continue;
            }
            return false;
        }
        return equals;
    }

    public Differences compareUnion(ProjectSettings other) {
        Differences diff = new Differences();
        for (Map.Entry<String, String> entry : this.user.entrySet()) {
            if (Objects.equals(entry.getValue(), other.user.get(entry.getKey()))) continue;
            diff.user.add(entry.getKey());
        }
        for (Map.Entry<String, String> entry : other.user.entrySet()) {
            if (Objects.equals(entry.getValue(), this.user.get(entry.getKey()))) continue;
            diff.user.add(entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : this.main.entrySet()) {
            if (ignoreKeys.contains((String)entry.getKey()) || !other.main.containsKey(entry.getKey()) || entry.getValue().equals(other.main.get(entry.getKey()))) continue;
            diff.main.add((String)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : this.skin.entrySet()) {
            if (ignoreKeys.contains((String)entry.getKey()) || !other.skin.containsKey((String)entry.getKey()) || entry.getValue().equals(other.skin.get(entry.getKey()))) continue;
            diff.skin.add((String)entry.getKey());
        }
        return diff;
    }

    private void log(String context, Map.Entry e, Object otherVal) {
        if (Config.getConfig().isDebugMode()) {
            if (this.firstLog) {
                System.out.println("");
                this.firstLog = false;
            }
            System.out.println(context + " property '" + String.valueOf(e.getKey()) + "' difference: '" + String.valueOf(e.getValue()) + "' vs '" + String.valueOf(otherVal) + "'");
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.main != null ? this.main.hashCode() : 0);
        hash = 19 * hash + (this.skin != null ? this.skin.hashCode() : 0);
        hash = 19 * hash + (this.user != null ? this.user.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectSettings other = (ProjectSettings)obj;
        if (!(this.main == other.main || this.main != null && this.main.equals(other.main))) {
            return false;
        }
        if (!(this.skin == other.skin || this.skin != null && this.skin.equals(other.skin))) {
            return false;
        }
        return this.user == other.user || this.user != null && this.user.equals(other.user);
    }

    public void save(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.save(fos);
        }
    }

    public void save(OutputStream os) throws IOException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.main);
        this.addUserVariables(props);
        this.addSkinVariables(props);
        props.store(os, "jAlbum Project");
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.save(bos);
        byte[] bytes = bos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    private void addUserVariables(Properties props) {
        for (Map.Entry<String, String> item : this.user.entrySet()) {
            props.setProperty("user." + String.valueOf(item.getKey()), item.getValue().toString());
        }
    }

    private void addSkinVariables(Properties props) {
        for (Map.Entry<String, Object> item : this.skin.entrySet()) {
            props.setProperty("skin." + String.valueOf(item.getKey()), item.getValue().toString());
        }
    }

    private void copyProps(Properties from, Properties to, String ... propertyNames) {
        for (String name : propertyNames) {
            String val = from.getProperty(name);
            if (val == null) continue;
            to.setProperty(name, val);
        }
    }

    static {
        ignoreKeys.add("cpuCores");
        ignoreKeys.add("albumWidth");
        ignoreKeys.add("albumHeight");
        ignoreKeys.add("jAlbumVersion");
        ignoreKeys.add("slides");
        ignoreKeys.add("internalVersion");
        ignoreKeys.add("displayVersion");
        SPECIFIC_KEYS.add("directory");
        SPECIFIC_KEYS.add("outputDirectory");
        SPECIFIC_KEYS.add("accountProfileName");
        SPECIFIC_KEYS.add("remoteDirectory");
        SPECIFIC_KEYS.add("notes");
    }

    public static class Differences {
        public Set<String> main = new HashSet<String>();
        public Set<String> skin = new HashSet<String>();
        public Set<String> user = new HashSet<String>();
    }
}

