/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.datadosen.jalbum.Config;
import se.datadosen.net.JettyHttpServer;
import se.datadosen.net.NetUtil;

public class PreviewServer
extends JettyHttpServer {
    public PreviewServer() {
        this.init();
    }

    private void init() {
        this.setHost("127.0.0.1");
        this.setPort(NetUtil.getFreeServerPort() + 1);
        Config.getConfig().addPropertyChangeListener("previewServerPort", pce -> {
            try {
                this.setPort(Integer.parseInt((String)pce.getNewValue()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    @Override
    public void setPort(int port) {
        super.setPort(port);
        if (this.isRunning()) {
            try {
                this.stop();
                this.start();
            }
            catch (Exception ex) {
                Logger.getLogger(PreviewServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void start() throws Exception {
        try {
            super.start();
        }
        catch (IOException ex) {
            try (ServerSocket ss = new ServerSocket(0);){
                this.setPort(ss.getLocalPort());
            }
            super.start();
        }
    }
}

