/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.properties.XMPProperty;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Objects;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.FileFilters;

public class PhotoSphere {
    public static final String USE_PANORAMA_VIEWER = "UsePanoramaViewer";
    public static final String PROJECTION_TYPE = "ProjectionType";
    public static final String PROJECTION_TYPE_DEFAULT = "equirectangular";
    public static final String POSE_HEADING_DEGREES = "PoseHeadingDegrees";
    public static final String POSE_PITCH_DEGREES = "PosePitchDegrees";
    public static final String POSE_ROLL_DEGREES = "PoseRollDegrees";
    public static final String INITIAL_VIEW_HEADING_DEGREES = "InitialViewHeadingDegrees";
    public static final String INITIAL_VIEW_PITCH_DEGREES = "InitialViewPitchDegrees";
    public static final String INITIAL_VIEW_ROLL_DEGREES = "InitialViewRollDegrees";
    public static final String INITIAL_HORIZONTAL_FOV_DEGREES = "InitialHorizontalFOVDegrees";
    public static final String CROPPED_AREA_IMAGE_WIDTH_PIXELS = "CroppedAreaImageWidthPixels";
    public static final String CROPPED_AREA_IMAGE_HEIGHT_PIXELS = "CroppedAreaImageHeightPixels";
    public static final String CROPPED_AREA_LEFT_PIXELS = "CroppedAreaLeftPixels";
    public static final String CROPPED_AREA_TOP_PIXELS = "CroppedAreaTopPixels";
    public static final String FULL_PANO_WIDTH_PIXELS = "FullPanoWidthPixels";
    public static final String FULL_PANO_HEIGHT_PIXELS = "FullPanoHeightPixels";

    public static void deleteXmpData(XMPMeta meta) {
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", USE_PANORAMA_VIEWER);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", PROJECTION_TYPE);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", POSE_HEADING_DEGREES);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", POSE_PITCH_DEGREES);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", POSE_ROLL_DEGREES);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", INITIAL_VIEW_HEADING_DEGREES);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", INITIAL_VIEW_PITCH_DEGREES);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", INITIAL_VIEW_ROLL_DEGREES);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", INITIAL_HORIZONTAL_FOV_DEGREES);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", CROPPED_AREA_IMAGE_WIDTH_PIXELS);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", CROPPED_AREA_IMAGE_HEIGHT_PIXELS);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", CROPPED_AREA_LEFT_PIXELS);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", CROPPED_AREA_TOP_PIXELS);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", FULL_PANO_WIDTH_PIXELS);
        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", FULL_PANO_HEIGHT_PIXELS);
    }

    public static BufferedImage scaleToPowerOfTwo(BufferedImage bi, AlbumBean engine) {
        int w;
        int width = bi.getWidth();
        int height = bi.getHeight();
        int h = 4096;
        for (w = 8192; w > width; w >>= 1) {
        }
        while (h > height) {
            h >>= 1;
        }
        if (w == width && h == height) {
            return bi;
        }
        return engine.scaleToFit(bi, new Dimension(w, h), "ScaleMedium");
    }

    public static boolean isPotentialPhotoSphere(AlbumObject ao) {
        if (ao.getCategory() == Category.image) {
            try {
                FileFilters.BasicImageInfo info = ao.getImageInfo();
                return info.width == info.height * 2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isPhotoSphere(AlbumObject ao) {
        if (!PhotoSphere.isPotentialPhotoSphere(ao)) {
            return false;
        }
        XmpManager mgr = ao.getXmpManager();
        if (mgr != null) {
            try {
                XMPMeta meta = mgr.getXMPMeta();
                String projectionType = meta.getPropertyString("http://ns.google.com/photos/1.0/panorama/", PROJECTION_TYPE);
                if (PROJECTION_TYPE_DEFAULT.equals(projectionType)) {
                    return true;
                }
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        return false;
    }

    static void addAutoCalculatedFields(AlbumObject ao, BufferedImage im) throws XMPException {
        int width = im.getWidth();
        int height = im.getHeight();
        XmpManager mgr = ao.getXmpManager();
        if (mgr != null) {
            XMPMeta meta = mgr.getXMPMeta();
            meta.setPropertyInteger("http://ns.google.com/photos/1.0/panorama/", CROPPED_AREA_IMAGE_WIDTH_PIXELS, width);
            meta.setPropertyInteger("http://ns.google.com/photos/1.0/panorama/", CROPPED_AREA_IMAGE_HEIGHT_PIXELS, height);
            meta.setPropertyInteger("http://ns.google.com/photos/1.0/panorama/", CROPPED_AREA_LEFT_PIXELS, 0);
            meta.setPropertyInteger("http://ns.google.com/photos/1.0/panorama/", CROPPED_AREA_TOP_PIXELS, 0);
            meta.setPropertyInteger("http://ns.google.com/photos/1.0/panorama/", FULL_PANO_WIDTH_PIXELS, width);
            meta.setPropertyInteger("http://ns.google.com/photos/1.0/panorama/", FULL_PANO_HEIGHT_PIXELS, height);
        }
    }

    public static class Model {
        @XMP(value="UsePanoramaViewer")
        boolean usePanoramaViewer;
        @XMP(value="ProjectionType")
        String projectionType = "";
        @XMP(value="InitialHorizontalFOVDegrees")
        double fieldOfView = 70.0;
        @XMP(value="PoseHeadingDegrees")
        double poseHeading = 0.0;
        @XMP(value="PosePitchDegrees")
        double posePitch = 0.0;
        @XMP(value="PoseRollDegrees")
        double poseRoll = 0.0;
        @XMP(value="InitialViewHeadingDegrees")
        int initialViewHeading = 0;
        @XMP(value="InitialViewPitchDegrees")
        int initialViewPitch = 0;
        @XMP(value="InitialViewRollDegrees")
        int initialViewRoll = 0;
        private static final Model defaultModel = new Model();

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + Objects.hashCode(this.projectionType);
            hash = 59 * hash + (int)(Double.doubleToLongBits(this.fieldOfView) ^ Double.doubleToLongBits(this.fieldOfView) >>> 32);
            hash = 59 * hash + (int)(Double.doubleToLongBits(this.poseHeading) ^ Double.doubleToLongBits(this.poseHeading) >>> 32);
            hash = 59 * hash + (int)(Double.doubleToLongBits(this.posePitch) ^ Double.doubleToLongBits(this.posePitch) >>> 32);
            hash = 59 * hash + (int)(Double.doubleToLongBits(this.poseRoll) ^ Double.doubleToLongBits(this.poseRoll) >>> 32);
            hash = 59 * hash + this.initialViewHeading;
            hash = 59 * hash + this.initialViewPitch;
            hash = 59 * hash + this.initialViewRoll;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Model other = (Model)obj;
            if (Double.doubleToLongBits(this.fieldOfView) != Double.doubleToLongBits(other.fieldOfView)) {
                return false;
            }
            if (Double.doubleToLongBits(this.poseHeading) != Double.doubleToLongBits(other.poseHeading)) {
                return false;
            }
            if (Double.doubleToLongBits(this.posePitch) != Double.doubleToLongBits(other.posePitch)) {
                return false;
            }
            if (Double.doubleToLongBits(this.poseRoll) != Double.doubleToLongBits(other.poseRoll)) {
                return false;
            }
            if (this.initialViewHeading != other.initialViewHeading) {
                return false;
            }
            if (this.initialViewPitch != other.initialViewPitch) {
                return false;
            }
            if (this.initialViewRoll != other.initialViewRoll) {
                return false;
            }
            return Objects.equals(this.projectionType, other.projectionType);
        }

        public String getProjectionType() {
            return this.projectionType;
        }

        public void setProjectionType(String projectionType) {
            this.projectionType = projectionType;
        }

        public double getFieldOfView() {
            return this.fieldOfView;
        }

        public void setFieldOfView(double fieldOfView) {
            this.fieldOfView = fieldOfView;
        }

        public double getPoseHeading() {
            return this.poseHeading;
        }

        public void setPoseHeading(double poseHeading) {
            this.poseHeading = poseHeading;
        }

        public double getPosePitch() {
            return this.posePitch;
        }

        public void setPosePitch(double posePitch) {
            this.posePitch = posePitch;
        }

        public double getPoseRoll() {
            return this.poseRoll;
        }

        public void setPoseRoll(double poseRoll) {
            this.poseRoll = poseRoll;
        }

        public int getInitialViewHeading() {
            return this.initialViewHeading;
        }

        public void setInitialViewHeading(int initialViewHeading) {
            this.initialViewHeading = initialViewHeading;
        }

        public int getInitialViewPitch() {
            return this.initialViewPitch;
        }

        public void setInitialViewPitch(int initialViewPitch) {
            this.initialViewPitch = initialViewPitch;
        }

        public int getInitialViewRoll() {
            return this.initialViewRoll;
        }

        public void setInitialViewRoll(int initialViewRoll) {
            this.initialViewRoll = initialViewRoll;
        }

        public void read(XMPMeta meta) throws XMPException {
            for (Field f : this.getClass().getDeclaredFields()) {
                try {
                    XMPProperty prop;
                    XMP a = f.getAnnotation(XMP.class);
                    if (a == null || (prop = meta.getProperty("http://ns.google.com/photos/1.0/panorama/", a.value())) == null) continue;
                    if (f.getType() == Double.TYPE) {
                        f.setDouble(this, Double.parseDouble(prop.getValue()));
                        continue;
                    }
                    if (f.getType() == Integer.TYPE) {
                        f.setInt(this, (int)Double.parseDouble(prop.getValue()));
                        continue;
                    }
                    if (f.getType() != String.class) continue;
                    f.set(this, prop.getValue());
                }
                catch (XMPException | IllegalAccessException | IllegalArgumentException ex) {
                    throw new RuntimeException("For " + f.getName(), ex);
                }
            }
        }

        public void write(XMPMeta meta) throws XMPException {
            if (!this.projectionType.equals(PhotoSphere.PROJECTION_TYPE_DEFAULT)) {
                PhotoSphere.deleteXmpData(meta);
            } else {
                try {
                    this.usePanoramaViewer = true;
                    for (Field f : this.getClass().getDeclaredFields()) {
                        XMP a = f.getAnnotation(XMP.class);
                        if (a == null) continue;
                        meta.deleteProperty("http://ns.google.com/photos/1.0/panorama/", a.value());
                        if (f.get(this).equals(defaultModel.getClass().getDeclaredField(f.getName()).get(defaultModel))) continue;
                        meta.setProperty("http://ns.google.com/photos/1.0/panorama/", a.value(), f.get(this));
                    }
                }
                catch (XMPException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        public static @interface XMP {
            public String value();
        }
    }
}

