/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import se.datadosen.jalbum.AbstractAlbumObjectFilter;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CategoryFilter;

public class Paginator
extends AbstractCollection<AlbumObject> {
    private CategoryFilter categoryFilter = new CategoryFilter();
    private VisibleFilter visibleFilter = new VisibleFilter(this.categoryFilter);
    private final AlbumBean engine;
    private int page = -1;
    private List<AlbumObject> items;
    private Collection<AlbumObject> allItems;

    public Paginator(AlbumBean engine, AlbumObject currentFolder) {
        this.engine = engine;
        this.allItems = currentFolder.getChildren();
    }

    public Paginator(AlbumBean engine, Collection<AlbumObject> allItems) {
        this.engine = engine;
        this.allItems = allItems;
    }

    public Paginator(Paginator original) {
        this.engine = original.engine;
        this.categoryFilter = new CategoryFilter(original.categoryFilter);
        this.categoryFilter.setNext(original.categoryFilter.getNext());
        this.visibleFilter = new VisibleFilter(this.categoryFilter);
        this.allItems = original.allItems;
        this.page = original.page;
        this.items = original.items;
    }

    public Paginator page(int page) {
        Paginator clone = new Paginator(this);
        clone.page = page;
        return clone;
    }

    public int getPage() {
        return this.page;
    }

    @Override
    public int size() {
        this.update();
        return this.page == -1 ? this.totalSize() : Math.min(this.getItemsPerPage(), this.totalSize() - this.page * this.getItemsPerPage());
    }

    public int totalSize() {
        this.update();
        return this.items.size();
    }

    public int totalPages() {
        this.update();
        int res = (int)Math.ceil((float)this.totalSize() / (float)this.getItemsPerPage());
        return res == 0 ? 1 : res;
    }

    public int getItemsPerPage() {
        return (this.engine.getRows() > 0 ? this.engine.getRows() : 999) * this.engine.getCols();
    }

    public Paginator include(Category ... cats) {
        Paginator clone = new Paginator(this);
        clone.categoryFilter.include(cats);
        clone.items = null;
        return clone;
    }

    public Paginator exclude(Category ... cats) {
        Paginator clone = new Paginator(this);
        clone.categoryFilter.exclude(cats);
        clone.items = null;
        return clone;
    }

    public Paginator include(String ... types) {
        Paginator clone = new Paginator(this);
        clone.categoryFilter.include(types);
        clone.items = null;
        return clone;
    }

    public Paginator exclude(String ... types) {
        Paginator clone = new Paginator(this);
        clone.categoryFilter.exclude(types);
        clone.items = null;
        return clone;
    }

    public Paginator dirs() {
        return this.include(Category.folder);
    }

    public Paginator nodirs() {
        return this.exclude(Category.folder);
    }

    public Paginator thumbnails() {
        return this.exclude(Category.folder, Category.webPage, Category.webLocation);
    }

    public Paginator filter(Predicate<AlbumObject> filter) {
        Paginator clone = new Paginator(this);
        clone.categoryFilter.setNext(filter);
        clone.items = null;
        return clone;
    }

    public Paginator reset() {
        this.page = -1;
        this.categoryFilter.reset();
        this.items = null;
        return this;
    }

    @Override
    public Iterator<AlbumObject> iterator() {
        this.update();
        return new PageIterator();
    }

    private void update() {
        if (this.items == null) {
            this.items = this.allItems.stream().filter(this.visibleFilter::test).collect(Collectors.toList());
        }
    }

    private static class VisibleFilter
    extends AbstractAlbumObjectFilter {
        public VisibleFilter(AbstractAlbumObjectFilter next) {
            super(next);
        }

        @Override
        protected boolean doTest(AlbumObject ao) {
            return VISIBLE_FILTER.test(ao);
        }
    }

    private class PageIterator
    implements Iterator<AlbumObject> {
        private int i = 0;

        private PageIterator() {
        }

        private int index(int i) {
            return (Paginator.this.page == -1 ? 0 : Paginator.this.page) * Paginator.this.getItemsPerPage() + i;
        }

        @Override
        public boolean hasNext() {
            if (Paginator.this.page == -1) {
                return this.i < Paginator.this.totalSize();
            }
            return this.i < Paginator.this.getItemsPerPage() && this.index(this.i) < Paginator.this.totalSize();
        }

        @Override
        public AlbumObject next() {
            try {
                return Paginator.this.items.get(this.index(this.i++));
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException("i=" + this.i);
            }
        }
    }
}

