/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import org.w3c.dom.Node;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CategoryCounters;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.Widget;
import se.datadosen.tags.ElementException;
import se.datadosen.util.IO;
import se.datadosen.util.StringUtil;

public class Notifier {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    JAlbumContext context;
    JAlbumSite site;

    public Notifier(JAlbumContext context) throws ElementException, IOException {
        this.context = context;
        this.site = JAlbumSite.getTrueInstance();
    }

    public boolean allowedToNotify(AccountProfile account) {
        AlbumBean engine = this.context.getEngine();
        return account.isMyjalbum() || SignInManager.getInstance().isSignedIn();
    }

    public String albumAdded(AccountProfile account, String albumUrl, AlbumProject project, boolean share) throws IOException {
        AlbumBean engine = this.context.getEngine();
        if (!this.allowedToNotify(account)) {
            return null;
        }
        String thumbnailPath = project.getRootFolder().getThumbnailPath();
        String cid = AccountManager.resolveCid(account);
        RobustResty r = new RobustResty();
        Properties data = new Properties();
        data.setProperty("jalbum.version", AlbumBean.getInternalVersion());
        data.setProperty("albumUrl", Notifier.urlEncode(albumUrl));
        if (thumbnailPath != null) {
            String part = albumUrl.substring(0, albumUrl.lastIndexOf(47));
            String thumbnailUrl = Notifier.urlEncode(IO.combinePaths(part, thumbnailPath));
            data.setProperty("thumbnailUrl", thumbnailUrl);
        }
        data.setProperty("albumName", project.getName());
        AlbumObjectProperties props = project.getRootFolder().getProperties();
        String albumTitle = (String)props.get("title");
        if (albumTitle != null) {
            data.setProperty("albumTitle", albumTitle);
        }
        CategoryCounters counters = JAlbumUtilities.countCategories(project.getRootFolder());
        Object tags = props.get("tags", "");
        if (props.get("ffmpegVideo", false).booleanValue() && counters.getCount(Category.video) > 0) {
            if (((String)(tags = ((String)tags).trim())).length() > 0 && !((String)tags).endsWith(",")) {
                tags = (String)tags + ",";
            }
            tags = (String)tags + "video";
        }
        if (((String)tags).length() > 0) {
            data.setProperty("tags", (String)tags);
        }
        data.setProperty("albumDescription", project.getRootFolder().getComment());
        data.setProperty("skin", engine.getSkin());
        data.setProperty("style", engine.getStyle());
        data.setProperty("imageCount", "" + counters.getCount(Category.image));
        data.setProperty("videoCount", "" + counters.getCount(Category.video));
        Set contributors = (Set)props.get("contributors");
        if (contributors != null) {
            data.setProperty("contributors", StringUtil.setToString(contributors));
        }
        if (cid != null) {
            data.setProperty("cid", cid);
        }
        data.setProperty("visibleOnProfilePage", "" + engine.isVisibleOnProfilePage());
        data.setProperty("notifyFollowers", "" + share);
        data.setProperty("showInRecentAlbumsList", "" + share);
        if (account.isMyjalbum()) {
            data.setProperty("password", engine.getWebPassword());
        }
        if (props.containsKey("widgets")) {
            List widgets = (List)props.get("widgets");
            for (Widget widget : widgets) {
                if (widget.getActive() == null) continue;
                data.setProperty("widget." + widget.getId(), widget.getActive().toString());
            }
        }
        this.log("albumAdded", data);
        try {
            Node node = (Node)r.xml(this.site.getAddAlbumUrl(), (AbstractContent)RobustResty.form(data)).get("/reply", Node.class);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String result = (String)xpath.evaluate("//result", node, XPathConstants.STRING);
            if (!"ok".equals(result)) {
                System.out.println("Posting albumUrl: " + String.valueOf(data.get("albumUrl")));
                System.out.println("Posting thumbnailUrl: " + String.valueOf(data.get("thumbnailUrl")));
                throw new IOException("Error while adding album. Server reported: " + (String)xpath.evaluate("//htmlMessage", node, XPathConstants.STRING));
            }
            String albumId = (String)xpath.evaluate("//albumId", node, XPathConstants.STRING);
            if (albumId.length() > 0) {
                props.put("albumId", albumId);
                props.remove("widgetsLocalChange");
            }
            return albumId.length() > 0 ? albumId : null;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    public void albumAddedBg(final AccountProfile account, final String albumUrl, final AlbumProject project, final boolean share) {
        Thread t = new Thread(this){
            final /* synthetic */ Notifier this$0;
            {
                this.this$0 = this$0;
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    this.this$0.albumAdded(account, albumUrl, project, share);
                }
                catch (IOException ex) {
                    this.this$0.log(ex);
                }
            }
        };
        t.start();
    }

    public void albumDeleted(AccountProfile account, String oldUrl) throws IOException {
        if (oldUrl == null || !this.allowedToNotify(account)) {
            return;
        }
        RobustResty r = new RobustResty();
        String cid = AccountManager.resolveCid(account);
        Properties p = new Properties();
        p.setProperty("oldUrl", Notifier.urlEncode(oldUrl));
        if (cid != null) {
            p.setProperty("cid", cid);
        }
        String res = r.text(this.site.getUpdateAlbumUrl(), (AbstractContent)RobustResty.form(p)).toString();
    }

    public void albumDeletedBg(final AccountProfile account, final String oldUrl) {
        Thread t = new Thread(this){
            final /* synthetic */ Notifier this$0;
            {
                this.this$0 = this$0;
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    this.this$0.albumDeleted(account, oldUrl);
                }
                catch (IOException ex) {
                    this.this$0.log(ex);
                }
            }
        };
        t.start();
    }

    public String albumMoved(AccountProfile account, String oldUrl, String newUrl) throws IOException {
        AlbumBean engine = this.context.getEngine();
        if (!this.allowedToNotify(account)) {
            return null;
        }
        String cid = AccountManager.resolveCid(account);
        Properties data = new Properties();
        data.setProperty("oldUrl", Notifier.urlEncode(oldUrl));
        data.setProperty("newUrl", Notifier.urlEncode(newUrl));
        if (cid != null) {
            data.setProperty("cid", cid);
        }
        this.log("albumMoved", data);
        RobustResty r = new RobustResty();
        return r.text(this.site.getUpdateAlbumUrl(), (AbstractContent)RobustResty.form(data)).toString();
    }

    public void albumMovedBg(final AccountProfile account, final String oldUrl, final String newUrl) {
        Thread t = new Thread(this){
            final /* synthetic */ Notifier this$0;
            {
                this.this$0 = this$0;
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    this.this$0.albumMoved(account, oldUrl, newUrl);
                }
                catch (IOException ex) {
                    this.this$0.log(ex);
                }
            }
        };
        t.start();
    }

    private void log(String text, Properties data) {
        if (Config.getConfig().isDebugMode()) {
            System.out.println(text + ":");
            for (Map.Entry<Object, Object> e : data.entrySet()) {
                System.out.println(String.valueOf(e.getKey()) + "=" + String.valueOf(e.getValue()));
            }
        }
    }

    private void log(Throwable t) {
        if (Config.getConfig().isDebugMode()) {
            t.printStackTrace();
        }
    }

    static String urlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException bytes) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f' || chars[i] == ' ' || chars[i] == '#' || chars[i] == '%' || chars[i] == '\'') {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }
}

