/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import se.datadosen.io.LinkFile;
import se.datadosen.io.RenamedFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.FileAlbumObject;
import se.datadosen.jalbum.LinkFileAlbumObject;
import se.datadosen.util.IO;

public class NoDiacriticsAlbumObjectFactory
extends AlbumObjectFactory {
    public NoDiacriticsAlbumObjectFactory(AlbumBean engine) {
        super(engine);
    }

    @Override
    public AlbumObject createInstance(File file, AlbumObject parent) {
        String origName;
        String name;
        if (this.isForAlbumMaking() && file instanceof LinkFile && ((LinkFile)file).isDynamic()) {
            file = ((LinkFile)file).getResolvedLink(this.engine);
        }
        if (!(name = IO.removeDiacritics(origName = file.getName())).equals(origName)) {
            if ((file = new RenamedFile(name, file)) instanceof LinkFile) {
                return new LinkFileAlbumObject(file, parent, this){

                    @Override
                    public String getTitle() {
                        String title = super.getTitle();
                        if (title != null && title.length() > 0) {
                            return title;
                        }
                        title = ((RenamedFile)this.file).getTargetName();
                        return this.isFolder() ? title : IO.baseName(title);
                    }
                };
            }
            return new FileAlbumObject(file, parent, this){

                @Override
                public String getTitle() {
                    String title = super.getTitle();
                    if (title != null && title.length() > 0) {
                        return title;
                    }
                    title = ((RenamedFile)this.file).getTargetName();
                    return this.isFolder() ? title : IO.baseName(title);
                }
            };
        }
        return super.createInstance(file, parent);
    }
}

