/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.Serializable;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.util.Platform;

public class MiniConfig
implements Serializable {
    private static MiniConfig theConfig;
    public File progDir;
    public File skinsDir;
    public File pluginsDir;
    public ChainedDirectory chainedExtDir;
    public File configDir;

    private MiniConfig() {
        this.setConfigDir();
        this.progDir = new File("").getAbsoluteFile();
        this.newProgDir();
        if (!this.skinsDir.exists()) {
            String instDirName = System.getProperty("jalbum.installation.dir");
            if (instDirName != null) {
                this.progDir = new File(instDirName);
            } else {
                String[] paths = System.getProperty("java.class.path").split(File.pathSeparator);
                File classPath = new File(System.getProperty("java.class.path"));
                for (String path : paths) {
                    if (!path.toLowerCase().contains("jalbum.jar")) continue;
                    classPath = new File(path);
                    break;
                }
                if (classPath.exists()) {
                    this.progDir = classPath.getAbsoluteFile().getParentFile();
                    System.setProperty("jalbum.installation.dir", this.progDir.getAbsolutePath());
                }
            }
            this.newProgDir();
        }
    }

    public static MiniConfig getMiniConfig() {
        if (theConfig == null) {
            theConfig = new MiniConfig();
        }
        return theConfig;
    }

    private void newProgDir() {
        this.skinsDir = new File(this.progDir, "skins");
        this.pluginsDir = new File(this.progDir, "plugins");
        this.chainedExtDir = new ChainedDirectory(new File(this.configDir, "ext"), new ChainedDirectory(new File(this.progDir, "ext")), ChainedDirectory.lastModifiedDecider);
    }

    private void setConfigDir() {
        File appdataDir = null;
        String appdata = System.getProperty("appdata");
        if (appdata == null) {
            try {
                appdata = System.getenv("APPDATA");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (appdata != null) {
            appdataDir = new File(appdata);
        } else if (Platform.isWindows()) {
            File f = new File(System.getProperty("user.home"), "Application Data");
            if (f.exists()) {
                appdataDir = f;
            }
        } else if (Platform.isMac()) {
            appdataDir = new File(System.getProperty("user.home"), "Library");
        } else {
            this.configDir = new File(System.getProperty("user.home"), ".jalbum");
        }
        if (appdataDir != null) {
            this.configDir = new File(appdataDir, "JAlbum");
        }
        if (this.configDir == null) {
            throw new RuntimeException("Couldn't find configuration directory. Check your APPDATA environment variable");
        }
    }
}

