/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.datadosen.jalbum.MiniConfig;

public final class Main {
    private static final MiniConfig config = MiniConfig.getMiniConfig();
    private static ClassLoader jAlbumClassLoader;
    private static Class jAlbumClass;

    public static void main(String[] args) throws ClassNotFoundException {
        Main.installUpdates();
        try {
            ClassLoader classLoader = Main.getJAlbumClassLoader();
            jAlbumClass = classLoader.loadClass("se.datadosen.jalbum.JAlbum");
            Thread.currentThread().setContextClassLoader(classLoader);
            Method method = jAlbumClass.getMethod("main", args.getClass());
            method.invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException t) {
            System.err.println("Error: " + t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    static void secondaryMain(String[] args) {
        try {
            Method method = jAlbumClass.getMethod("secondaryMain", args.getClass());
            method.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException t) {
            t.printStackTrace(System.err);
        }
    }

    public static ClassLoader getJAlbumClassLoader() {
        if (jAlbumClassLoader == null) {
            File libDir = new File(Main.config.progDir, "lib");
            ArrayList<URL> all = new ArrayList<URL>();
            all.addAll(Main.buildURLList(libDir));
            all.addAll(Main.buildURLList(Main.config.chainedExtDir));
            try {
                all.add(Main.config.pluginsDir.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            URL[] allURLs = all.toArray(new URL[all.size()]);
            jAlbumClassLoader = new URLClassLoader(allURLs, Main.class.getClassLoader());
        }
        return jAlbumClassLoader;
    }

    static List<File> buildFileList(File dir) {
        Object[] files = dir.listFiles(f -> {
            String s = f.getName().toLowerCase();
            return s.endsWith(".jar") || s.endsWith(".zip") || s.endsWith(".jaext");
        });
        if (files == null) {
            files = new File[]{};
        }
        Arrays.sort(files);
        return Arrays.asList(files);
    }

    public static List<URL> buildURLList(File dir) {
        List<File> files = Main.buildFileList(dir);
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (File f : files) {
                urls.add(f.toURI().toURL());
            }
            return urls;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void installUpdates() {
        Main.installUpdates(new File(Main.config.progDir, "ext"));
        Main.installUpdates(new File(Main.config.progDir, "lib"));
    }

    private static void installUpdates(File dir) {
        if (!dir.exists()) {
            return;
        }
        for (File newFile : dir.listFiles(pathname -> pathname.getName().endsWith(".downloaded"))) {
            if (newFile.length() > 0L) {
                String name = newFile.getName();
                String base = name.substring(0, name.lastIndexOf(46));
                File jarFile = new File(dir, base);
                File oldFile = new File(dir, base + ".old");
                if (jarFile.exists()) {
                    if (oldFile.exists()) {
                        oldFile.delete();
                    }
                    jarFile.renameTo(oldFile);
                }
                if (!newFile.renameTo(jarFile)) continue;
                System.out.println("Installed update of " + String.valueOf(jarFile));
                continue;
            }
            newFile.delete();
        }
    }

    static {
        System.setProperty("jalbum.file.encoding", System.getProperty("file.encoding"));
        if ("MacRoman".equals(System.getProperty("jalbum.file.encoding"))) {
            System.setProperty("jalbum.file.encoding", "ISO-8859-1");
        }
    }
}

