/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.util.List;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.FileAlbumObject;
import se.datadosen.util.IO;

public class LinkFileAlbumObject
extends FileAlbumObject {
    private transient Boolean internal;
    private AlbumObject internalTarget;

    public LinkFileAlbumObject(File file, AlbumObject parent, AlbumObjectFactory factory) {
        super(file, parent, factory);
    }

    @Override
    public AlbumObjectProperties getProperties() {
        this.getInternalTarget();
        return this.internalTarget != null && this.internalTarget != this ? this.internalTarget.getProperties() : super.getProperties();
    }

    @Override
    public Attachments getAttachments() {
        this.getInternalTarget();
        return this.internalTarget != null && this.internalTarget != this ? this.internalTarget.getAttachments() : super.getAttachments();
    }

    @Override
    public boolean isLink() {
        return true;
    }

    @Override
    public boolean isInternalLink() {
        if (this.internal == null) {
            this.internal = IO.isSubdirectoryOf(LinkFile.targetOf(this.getFile()), this.getEngine().getRootImageDir());
        }
        return this.internal;
    }

    public AlbumObject getInternalTarget() {
        String childPath;
        AlbumObject root;
        AlbumObject it;
        if (this.internalTarget == null && this.isInternalLink() && (it = (root = this.getRoot()).getChild(childPath = root.getPath().relativize(LinkFile.linkOf(LinkFile.targetOf(this.getFile())).toPath()).toString().replace(File.separatorChar, '/'))) != this) {
            this.internalTarget = it;
        }
        return this.internalTarget;
    }

    @Override
    public List<AlbumObject> getChildren(boolean ordered) throws UncheckedIOException {
        if ((this.children == null || this.children.get() == null) && this.getEngine().isLinkInternally(this)) {
            List<AlbumObject> children = this.getInternalTarget().getChildren(ordered);
            this.children = new SoftReference<List<AlbumObject>>(children);
            return children;
        }
        return super.getChildren(ordered);
    }

    @Override
    protected AlbumObjectImpl getRepObject(AlbumObjectImpl.VisitorContext ctx) {
        AlbumObjectImpl rep;
        if (this.getEngine().isLinkInternally(this) && (rep = (AlbumObjectImpl)this.getInternalTarget()) != null) {
            AlbumObjectImpl rep2 = rep.getRepObject(ctx);
            rep = rep2 != null ? rep2 : rep;
            this.setRep(rep);
            return rep;
        }
        return super.getRepObject(ctx);
    }
}

