/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.FileNotFoundException;
import java.util.Map;
import se.datadosen.component.ControlPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.EditListener2;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.util.Debug;
import se.datadosen.util.PropertyBinder;

public class JWebPageUI
extends ControlPanel
implements EditListener2,
JAlbumPlugin {
    protected JAlbumContext context;
    protected PluginContext pc;
    private Map initiatedValues;
    protected AlbumObject currentAO;
    private boolean loadingUI = false;

    @Override
    public void init(PluginContext context) {
        this.context = context.getJAlbumContext();
        this.pc = context;
        this.setOpaque(false);
    }

    @Override
    public void setAlbumObject(AlbumObject ao) {
        this.saveUI();
        this.currentAO = ao;
        this.loadUI();
    }

    private void initUI() {
        if (this.initiatedValues == null) {
            this.initiatedValues = PropertyBinder.getProperties(this);
        } else {
            PropertyBinder.syncUI(this.initiatedValues, this);
        }
    }

    protected boolean isLoadingUI() {
        return this.loadingUI;
    }

    protected void loadUI() {
        try {
            this.loadingUI = true;
            this.initUI();
            if (this.currentAO != null) {
                AlbumObjectProperties props = this.currentAO.getProperties();
                props.loadUI(this);
            }
        }
        finally {
            this.loadingUI = false;
        }
    }

    protected void init() {
        this.loadUI();
    }

    protected void saveUI() {
        if (this.currentAO == null || this.loadingUI) {
            return;
        }
        AlbumObjectProperties props = this.currentAO.getProperties();
        try {
            props.saveUI(this);
        }
        catch (FileNotFoundException ex) {
            Debug.showFriendlyErrorDialog(this, ex);
        }
    }

    @Override
    public boolean onExit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void saveState() {
        this.saveUI();
    }
}

