/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import net.jalbum.OutputFormat;
import net.jalbum.Variant;
import se.datadosen.component.JNumberField;
import se.datadosen.component.JPlainButton;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;

public class JVariantsEditor
extends JPanel {
    private JTable table;
    private VariantModel model;
    private TableRowSorter<VariantModel> sorter;
    private JScrollPane scroller;
    private Action addAction = new AbstractAction(null, Icons.small("plain-plus")){
        {
            this.putValue("ShortDescription", Msg.get("ui.addVariant"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Variant current = null;
            Variant previous = null;
            for (Variant v : JVariantsEditor.this.model.getVariants()) {
                previous = current;
                current = v;
            }
            OutputFormat format = OutputFormat.JPEG;
            float step = 2.0f;
            if (current != null) {
                format = current.getFormat();
                step = current.getScale() + 1.0f;
            }
            if (previous != null) {
                step = current.getScale() + Math.abs(current.getScale() - previous.getScale());
            }
            step = Math.min(step, 4.0f);
            JVariantsEditor.this.model.addVariant(new Variant(step, format));
        }
    };
    private Action removeAction = new AbstractAction(null, Icons.small("plain-minus")){
        {
            this.putValue("ShortDescription", Msg.get("ui.removeVariant"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JVariantsEditor.this.table.getSelectedRow() > -1) {
                JVariantsEditor.this.model.removeRows(JVariantsEditor.this.table.getSelectionModel().getSelectedIndices());
            }
        }
    };
    private JPlainButton addButton = new JPlainButton(this.addAction);
    private JPlainButton removeButton = new JPlainButton(this.removeAction);

    public JVariantsEditor() {
        this.setLayout(new BorderLayout());
        this.model = new VariantModel(new ArrayList<Variant>());
        this.table = new JTable(this.model);
        this.sorter = new TableRowSorter<VariantModel>(this.model);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.DESCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.table.setRowSorter(this.sorter);
        this.sorter.sort();
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(192, 72));
        this.table.setFillsViewportHeight(true);
        TableColumn scaleColumn = this.table.getColumnModel().getColumn(0);
        JNumberField numField = new JNumberField();
        numField.setAllowDecimals(true);
        scaleColumn.setCellEditor(new DefaultCellEditor(numField));
        DefaultTableCellRenderer scaleRenderer = new DefaultTableCellRenderer();
        scaleRenderer.setHorizontalAlignment(4);
        scaleColumn.setCellRenderer(scaleRenderer);
        TableColumn formatColumn = this.table.getColumnModel().getColumn(1);
        JComboBox<OutputFormat> comboBox = new JComboBox<OutputFormat>(OutputFormat.values());
        formatColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer formatRenderer = new DefaultTableCellRenderer();
        formatRenderer.setHorizontalAlignment(0);
        formatColumn.setCellRenderer(formatRenderer);
        this.sorter.setSortsOnUpdates(true);
        this.scroller = new JScrollPane(this.table);
        this.add(this.scroller);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(this.addButton);
        buttonBox.add(this.removeButton);
        this.add((Component)buttonBox, "South");
    }

    public void dataChanged() {
        this.model.fireTableDataChanged();
        this.sorter.allRowsChanged();
    }

    public void setData(List<Variant> data) {
        this.model.setData(data);
        this.sorter.allRowsChanged();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.scroller.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    public class VariantModel
    extends AbstractTableModel {
        private List<Variant> variants;

        public List<Variant> getVariants() {
            return this.variants;
        }

        public VariantModel(List<Variant> variants) {
            this.variants = variants;
        }

        @Override
        public int getRowCount() {
            return this.variants.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            String[] names = new String[]{Msg.get("ui.scale"), Msg.get("ui.imageFormat")};
            return names[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Float.class;
                }
                case 1: {
                    return OutputFormat.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Variant v = this.variants.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return Float.valueOf(v.getScale());
                }
                case 1: {
                    return v.getFormat();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            try {
                Variant v = this.variants.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        try {
                            v.setScale(Float.parseFloat(aValue.toString()));
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        catch (IllegalArgumentException ex) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(JVariantsEditor.this, ex.getMessage(), "", 0);
                        }
                        break;
                    }
                    case 1: {
                        v.setFormat((OutputFormat)((Object)aValue));
                    }
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public void addVariant(Variant v) {
            this.variants.add(v);
            this.fireTableRowsInserted(this.variants.size() - 1, this.variants.size() - 1);
            int row = JVariantsEditor.this.table.convertRowIndexToView(this.variants.size() - 1);
            JVariantsEditor.this.table.getSelectionModel().setSelectionInterval(row, row);
        }

        public void clear() {
            int lastIndex = this.variants.size() - 1;
            this.variants.clear();
            if (lastIndex >= 0) {
                this.fireTableRowsDeleted(0, lastIndex);
            }
        }

        public void setData(List<Variant> data) {
            this.variants = data;
            this.fireTableDataChanged();
        }

        public void removeRows(int[] tableRows) {
            int i;
            int[] modelRows = new int[tableRows.length];
            for (i = 0; i < tableRows.length; ++i) {
                modelRows[i] = JVariantsEditor.this.table.convertRowIndexToModel(tableRows[i]);
            }
            Arrays.sort(modelRows);
            for (i = modelRows.length - 1; i >= 0; --i) {
                this.variants.remove(modelRows[i]);
                int tableRow = JVariantsEditor.this.table.convertRowIndexToView(modelRows[i]);
                this.fireTableRowsDeleted(tableRow, tableRow);
            }
            int selected = tableRows[0];
            if (selected >= this.variants.size()) {
                --selected;
            }
            if (selected >= 0) {
                JVariantsEditor.this.table.getSelectionModel().setSelectionInterval(selected, selected);
            }
            JVariantsEditor.this.sorter.sort();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }
}

