/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.util.Platform;

class JSmartFrame
extends JFrame {
    private final JPanel content = new JPanel();
    private final List<Action> additionalActions = new ArrayList<Action>(2);
    private final JFrame owner;

    public JSmartFrame(JFrame owner) throws HeadlessException {
        this.owner = owner;
        this.init();
    }

    private void init() {
        this.content.setLayout(new BorderLayout());
        this.content.setBorder(null);
        super.getContentPane().add((Component)this.content, "Center");
        if (!Platform.isMac()) {
            JAlbumFrameIcons icons = JAlbumFrameIcons.getInstance();
            try {
                this.setIconImages(icons.getWindowIcons());
            }
            catch (NoSuchMethodError ex) {
                this.setIconImage(icons.windowIcon.getImage());
            }
        }
    }

    protected void addAction(Action action) {
        this.additionalActions.add(action);
    }

    protected void registerActions(Action okAction) {
        this.registerActions(okAction, null);
    }

    protected void registerActions(final Action okAction, final Action cancelAction) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(cancelAction != null ? 2 : 1));
        JButton okButton = new JButton(okAction);
        JButton cancelButton = null;
        if (cancelAction != null) {
            cancelButton = new JButton(cancelAction);
        }
        if (JSmartFrame.isMac()) {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 9, 7, 13));
            for (Action a : this.additionalActions) {
                buttonPanel.add(new JButton(a));
            }
            if (cancelAction != null) {
                buttonPanel.add(cancelButton);
            }
            buttonPanel.add(okButton);
        } else {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
            buttonPanel.add(okButton);
            if (cancelAction != null) {
                buttonPanel.add(cancelButton);
            }
            for (Action a : this.additionalActions) {
                buttonPanel.add(new JButton(a));
            }
        }
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        AbstractAction closeAction = new AbstractAction(this, "close"){
            final /* synthetic */ JSmartFrame this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cancelAction != null) {
                    cancelAction.actionPerformed(null);
                } else {
                    okAction.actionPerformed(null);
                }
            }
        };
        pane.registerKeyboardAction(closeAction, "close", ks, 2);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ JSmartFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (cancelAction != null) {
                    cancelAction.actionPerformed(null);
                } else {
                    okAction.actionPerformed(null);
                }
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        Container c = super.getContentPane();
        c.add((Component)buttonPanel, "South");
    }

    private static boolean isMac() {
        return System.getProperty("mrj.version") != null;
    }

    @Override
    public Container getContentPane() {
        return this.content;
    }

    protected Container getRealContentPane() {
        return super.getContentPane();
    }

    public Window getMyOwner() {
        return this.owner;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.isVisible()) {
            Dimension dialogSize = this.getPreferredSize();
            Rectangle parentBounds = this.getMyOwner().getBounds();
            int xpos = (parentBounds.width - dialogSize.width) / 2 + parentBounds.x;
            int ypos = (parentBounds.height - dialogSize.height) / 2 + parentBounds.y;
            this.setLocation(xpos, ypos);
        }
        super.setVisible(visible);
    }
}

