/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import net.jalbum.resty.web.Resty;
import net.jalbum.resty.web.XMLResource;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JPackingCollapsiblePanel;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.RiverLayout;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.util.AliasAction;
import se.datadosen.util.IO;
import se.datadosen.util.VersionNumber;

public class JSkinInfo
extends JDialog {
    JAlbumContext context;
    SkinProperties props;
    JLinkLabel moreSkinsLink = new JLinkLabel();
    JCollapsiblePanel generalPanel = new JPackingCollapsiblePanel(Msg.get("skinInfo.general"), new RiverLayout());
    JCollapsiblePanel featurePanel = new JPackingCollapsiblePanel(Msg.get("skinInfo.features"), (LayoutManager)new MigLayout("insets 8, wrap 2", "[]20[]"));
    JPanel buttonPanel = new JPanel(new RiverLayout());
    JProgressSpinner versionSpinner = new JProgressSpinner(16, true);
    JProgressSpinner featureSpinner = new JProgressSpinner(32, true);
    RemoteInformationWorker remoteInfoWorker;
    Action updateSkin = new AbstractAction(Msg.get("edit.update")){
        {
            this.putValue("SmallIcon", Icons.small("download"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String skinName = JSkinInfo.this.props.getProperty("title");
            SkinManager sm = new SkinManager();
            try {
                URL url = new URL(JAlbumSite.getInstance().getSkinDownloadUrl(skinName));
                sm.installSkin(skinName, url, null);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(JSkinInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    Action deleteSkin = new AbstractAction(Msg.get("edit.delete")){
        {
            this.putValue("SmallIcon", Icons.small("delete"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JAlbumFrame window = JSkinInfo.this.context.getFrame();
            JSkinInfo.this.context.getFrame().ui2Engine();
            String name = JSkinInfo.this.context.getEngine().getSkin();
            int answer = JOptionPane.showConfirmDialog(window, Msg.get("skinInfo.deleteQuestion", name), Msg.get("skinInfo.deleteLabel"), 0, 2);
            if (answer != 0) {
                return;
            }
            ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
            File skinDir = chainedSkinsDir.getFile(name);
            try {
                JSkinInfo.this.context.getEngine().unloadCurrentSkin();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JSkinInfo.this.context.getEngine().setSkin("");
            IO.recycle(skinDir);
            File remainingSkinDir = chainedSkinsDir.getFile(name);
            if (remainingSkinDir.exists() && !remainingSkinDir.equals(skinDir)) {
                JOptionPane.showMessageDialog(window, Msg.get("skinInfo.deleteInfo", name), Msg.get("skinInfo.deleteLabel"), 1);
                JSkinInfo.this.context.getEngine().setSkin(name);
            }
            window.mainSettingsPanel.scanSkins();
            JSkinInfo.this.update();
        }
    };
    Action resetDefaults = new AbstractAction(Msg.get("ui.resetDefaults")){
        {
            this.putValue("SmallIcon", Icons.small("reset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JSkinInfo.this.context.getFrame().getSkinDefaultsFile().delete()) {
                JSkinInfo.this.context.getFrame().statusBar.setText(Msg.get("ui.skinDefaultsResetInfo"));
            }
        }
    };
    Action closeAction = new AbstractAction("close"){

        @Override
        public void actionPerformed(ActionEvent e) {
            JSkinInfo.this.onClose();
            JSkinInfo.this.setVisible(false);
        }
    };
    JLabel name;
    JLabel author;
    JLabel currentVersion;
    JLabel latestVersion;
    JLinkLabel downloadURL;
    JLinkLabel supportURL;
    JLinkLabel homepageURL;
    JLinkLabel location;
    JButton deleteButton = new JButton(this.deleteSkin);
    JButton updateButton = new JButton(this.updateSkin);
    JButton resetButton = new JButton(this.resetDefaults);
    JButton settingsButton;

    public JSkinInfo(JAlbumContext context) {
        super((Frame)context.getFrame(), Msg.get("skinInfo.title"));
        try {
            this.context = context;
            this.latestVersion = new JLabel();
            this.latestVersion.setVisible(false);
            this.setLayout(new RiverLayout());
            this.init();
        }
        catch (Exception ex) {
            Logger.getLogger(JSkinInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void onClose() {
        if (this.remoteInfoWorker != null) {
            this.remoteInfoWorker.cancel(true);
        }
    }

    private void init() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        pane.registerKeyboardAction(this.closeAction, "close", ks, 2);
        this.moreSkinsLink.setText(Msg.get("ui.downloadSkins"));
        this.moreSkinsLink.setToolTipText(Msg.get("ui.downloadSkinsToolTip"));
        this.moreSkinsLink.setURL(JAlbumSite.getInstance().getSkinsUrl());
        this.update();
        this.settingsButton = new JButton(new AliasAction(this.context.getFrame().actions.skinSettingsAction, Msg.get("ui.settings")));
        this.updateButton.setVisible(false);
        this.add("br hfill", this.generalPanel);
        this.add("br hfill", this.featurePanel);
        this.add("br hfill", this.buttonPanel);
        this.buttonPanel.add("br", this.settingsButton);
        this.buttonPanel.add("tab", this.updateButton);
        this.buttonPanel.add("tab", this.deleteButton);
        this.buttonPanel.add("tab", this.resetButton);
        this.buttonPanel.add("br right", this.moreSkinsLink);
        this.generalPanel.setExpanded(true);
        this.featurePanel.setExpanded(true);
        this.pack();
        this.context.getFrame().addPropertyChangeListener("skinLoaded", evt -> {
            if (this.isVisible()) {
                this.update();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JSkinInfo.this.update();
            }
        });
        this.deleteButton.setFocusable(false);
        this.settingsButton.setFocusable(false);
        this.updateButton.setFocusable(false);
        this.setResizable(false);
    }

    public void update() {
        File programDir;
        ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
        String skinName = this.context.getEngine().getSkin();
        File skinDir = chainedSkinsDir.getFile(skinName);
        if (IO.isSubdirectoryOf(skinDir, programDir = MiniConfig.getMiniConfig().progDir)) {
            this.deleteSkin.setEnabled(false);
        } else {
            this.deleteSkin.setEnabled(true);
        }
        this.props = this.context.getEngine().getSkinProperties();
        this.name = new JLabel(this.props.getProperty("title"));
        this.author = new JLabel(this.props.getProperty("author"));
        this.currentVersion = new JLabel(this.props.getProperty("version"));
        try {
            String dlURL = URLDecoder.decode(JAlbumSite.getInstance().getSkinUrl(skinName), "UTF-8");
            this.downloadURL = new JLinkLabel(dlURL);
            this.downloadURL.setURL(dlURL);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        this.supportURL = new JLinkLabel(this.props.getProperty("supportForum"));
        this.supportURL.setURL(this.props.getProperty("supportForum"));
        this.homepageURL = new JLinkLabel(this.props.getProperty("homePage"));
        this.homepageURL.setURL(this.props.getProperty("homePage"));
        this.location = new JLinkLabel("http://www.dummy.com", skinDir.getAbsolutePath());
        this.location.addActionListener(e -> {
            try {
                BrowserLauncher.openLocal(skinDir);
            }
            catch (IOException ex) {
                Logger.getLogger(JSkinInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.generalPanel.getContentPanel().removeAll();
        this.featurePanel.getContentPanel().removeAll();
        this.generalPanel.add("br", new JLabel(Msg.get("skinInfo.name") + ":"));
        this.generalPanel.add("tab", this.name);
        this.generalPanel.add("br", new JLabel(Msg.get("skinInfo.author") + ":"));
        this.generalPanel.add("tab", this.author);
        this.generalPanel.add("br", new JLabel(Msg.get("skinInfo.currentVersion") + ":"));
        this.generalPanel.add("tab", this.currentVersion);
        this.generalPanel.add("br", new JLabel(Msg.get("skinInfo.latestVersion") + ":"));
        this.generalPanel.add("tab", this.versionSpinner);
        this.generalPanel.add("tab", this.latestVersion);
        this.generalPanel.add("br", new JLabel(Msg.get("skinInfo.downloadURL") + ":"));
        this.generalPanel.add("tab", this.downloadURL);
        this.generalPanel.add("br", new JLabel(Msg.get("skinInfo.supportURL") + ":"));
        this.generalPanel.add("tab", this.supportURL);
        this.generalPanel.add("br", new JLabel(Msg.get("skinInfo.homepageURL") + ":"));
        this.generalPanel.add("tab", this.homepageURL);
        this.generalPanel.add("br", new JLabel(Msg.get("info.location") + ":"));
        this.generalPanel.add("tab", this.location);
        this.updateButton.setVisible(false);
        this.featurePanel.add((Component)this.featureSpinner, "wrap");
        this.pack();
        this.remoteInfoWorker = new RemoteInformationWorker();
        this.remoteInfoWorker.execute();
    }

    class RemoteInformationWorker
    extends SwingWorker<XMLResource, Object> {
        RemoteInformationWorker() {
        }

        @Override
        protected XMLResource doInBackground() throws Exception {
            String name = JSkinInfo.this.props.getProperty("title");
            if (name == null) {
                name = JSkinInfo.this.context.getEngine().getSkin();
            }
            XMLResource remoteInfo = new Resty(new Resty.Option[0]).xml("http://jalbum.net/integration/skin-info/" + IO.urlEncode(name));
            return remoteInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                XMLResource remoteInfo = (XMLResource)this.get();
                if (remoteInfo != null && remoteInfo.get("/reply/skin").item(0) != null) {
                    this.checkVersion(remoteInfo);
                    this.setSkinURLs(remoteInfo);
                    List<JLabel> featureList = this.createFeatureList(remoteInfo);
                    if (featureList != null) {
                        JSkinInfo.this.featurePanel.getContentPanel().removeAll();
                        for (JLabel label : featureList) {
                            JSkinInfo.this.featurePanel.add(label);
                        }
                    }
                } else {
                    this.remoteUnavailable();
                }
            }
            catch (Exception ignore) {
                this.remoteUnavailable();
            }
            finally {
                JSkinInfo.this.featurePanel.getContentPanel().remove(JSkinInfo.this.featureSpinner);
                JSkinInfo.this.pack();
            }
        }

        private void setSkinURLs(XMLResource remoteInfo) throws Exception {
            String supportForumUrl = (String)remoteInfo.get("/reply/skin/supportForumUrl", String.class);
            String homepageUrl = (String)remoteInfo.get("/reply/skin/homepageUrl", String.class);
            JSkinInfo.this.supportURL.setText(supportForumUrl);
            JSkinInfo.this.supportURL.setURL(supportForumUrl);
            JSkinInfo.this.homepageURL.setText(homepageUrl);
            JSkinInfo.this.homepageURL.setURL(homepageUrl);
        }

        private void checkVersion(XMLResource remoteInfo) {
            try {
                String remoteVersion = (String)remoteInfo.get("/reply/skin/current-version", String.class);
                JSkinInfo.this.versionSpinner.setVisible(false);
                JSkinInfo.this.latestVersion.setText(remoteVersion);
                JSkinInfo.this.latestVersion.setVisible(true);
                if (new VersionNumber(JSkinInfo.this.currentVersion.getText()).compareTo(new VersionNumber(JSkinInfo.this.latestVersion.getText())) < 0) {
                    JSkinInfo.this.updateButton.setVisible(true);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(JSkinInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        private void remoteUnavailable() {
            JSkinInfo.this.versionSpinner.setVisible(false);
            JSkinInfo.this.latestVersion.setText("???");
            JSkinInfo.this.latestVersion.setVisible(true);
            JSkinInfo.this.featurePanel.getContentPanel().removeAll();
            JLabel noInfo = new JLabel(Msg.get("skinInfo.noRemoteInfo"));
            JSkinInfo.this.featurePanel.add(noInfo);
        }

        private List<JLabel> createFeatureList(XMLResource remoteInfo) throws Exception {
            ArrayList<JLabel> featureList = new ArrayList<JLabel>();
            NodeList features = remoteInfo.get("/reply/features/feature");
            for (int i = 0; i < features.getLength(); ++i) {
                NamedNodeMap attrs = features.item(i).getAttributes();
                URL iconUrl = new URL(attrs.getNamedItem("iconUrl").getTextContent());
                JAlbum.logger.finer("Icon: " + String.valueOf(iconUrl));
                ImageIcon image = new ImageIcon(iconUrl);
                JLabel imageLabel = new JLabel(attrs.getNamedItem("description").getTextContent(), image, 0);
                featureList.add(imageLabel);
            }
            return featureList;
        }
    }
}

