/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.jalbum.UsageCounters;
import se.datadosen.component.JIconTextField;
import se.datadosen.component.JModalPanel;
import se.datadosen.component.search.AlbumObjectTarget;
import se.datadosen.component.search.ProjectTarget;
import se.datadosen.component.search.SearchSupport;
import se.datadosen.component.search.Target;
import se.datadosen.component.search.TargetProvider;
import se.datadosen.component.search.UITarget;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.util.LambdaAction;

public class JSearchBar
extends JModalPanel<JAlbumFrame> {
    private JIconTextField searchField = new JIconTextField(16){
        int radius;
        {
            this.radius = 32;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getBackground());
            g2.translate(1, 1);
            g2.fillRoundRect(0, 0, this.getWidth() - 2, this.getHeight() - 2, this.radius, this.radius);
            g2.translate(-0.5, -0.5);
            g2.setColor(JAlbumColor.imageBorder);
            g2.drawRoundRect(0, 0, this.getWidth() - 2, this.getHeight() - 2, this.radius, this.radius);
            g2.dispose();
            super.paintComponent(g);
        }

        @Override
        protected void paintBorder(Graphics g) {
        }
    };
    private SearchSupport searchSupport;

    public JSearchBar(JAlbumFrame window) {
        super(window);
        this.searchField.setIcon(Icons.toolbar("btn-view"));
        this.searchField.setFont(this.searchField.getFont().deriveFont(20.0f));
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JSearchBar.this.close();
            }
        });
        this.searchField.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new LambdaAction(() -> this.close()));
        this.searchSupport = new SearchSupport(this.searchField, new TargetProvider[0]){

            @Override
            protected void acceptedListItem(InputEvent ie, Target selected) {
                JSearchBar.this.close();
                SwingUtilities.invokeLater(() -> {
                    UsageCounters.increase("searchSupport");
                    super.acceptedListItem(ie, selected);
                });
            }
        };
        this.add(this.searchField);
        this.validate();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.searchSupport.setProviders(new ArrayList<TargetProvider>());
            this.searchSupport.addProvider(new UITarget.Provider(((JAlbumFrame)this.window).mainSettingsPanel));
            this.searchSupport.addProvider(new UITarget.Provider(((JAlbumFrame)this.window).settingsWindow));
            this.searchSupport.addProvider(new UITarget.Provider(((JAlbumFrame)this.window).preferencesWindow));
            this.searchSupport.addProvider(new UITarget.Provider(((JAlbumFrame)this.window).shareWindow));
            this.searchSupport.addProvider(new UITarget.Provider(((JAlbumFrame)this.window).publishWizard));
            this.searchSupport.addProvider(new ProjectTarget.Provider());
            if (Config.getConfig().isIndexAlbumObjects()) {
                this.searchSupport.addProvider(new AlbumObjectTarget.Provider());
            }
            this.searchField.requestFocusInWindow();
        }
    }
}

