/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.util.IO;

class JSONImporter {
    JSONImporter() {
    }

    public static void importFromURL(URL url, AlbumObject dest) throws IOException, JsonException {
        URL dataURL = new URL(IO.combinePaths(url.toExternalForm(), "data1.json"));
        URLConnection conn = dataURL.openConnection();
        InputStreamReader reader = new InputStreamReader(conn.getInputStream());
        JsonObject rootObject = (JsonObject)Jsoner.deserialize((Reader)reader);
        JsonArray folders = (JsonArray)rootObject.get((Object)"objects");
        for (Object ch : folders) {
            String keywords;
            String title;
            JsonObject child = (JsonObject)ch;
            AlbumObject matchingChild = dest.getChild((String)child.get((Object)"name"));
            if (matchingChild == null) continue;
            String comment = (String)child.get((Object)"comment");
            if (comment != null) {
                matchingChild.setComment(comment);
                System.out.println("Setting comment for " + String.valueOf(matchingChild));
            }
            if ((title = (String)child.get((Object)"title")) != null) {
                matchingChild.setTitle(title);
                System.out.println("Setting title for " + String.valueOf(matchingChild));
            }
            if ((keywords = (String)child.get((Object)"keywords")) != null) {
                matchingChild.setKeywords(keywords);
                System.out.println("Setting keywords for " + String.valueOf(matchingChild));
            }
            if (!"folder".equals(child.get((Object)"category"))) continue;
            JSONImporter.importFromURL(new URL(url.toExternalForm() + "/" + String.valueOf(child.get((Object)"path"))), matchingChild);
        }
    }
}

