/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.jalbum.jlibraw.Gamma;
import net.jalbum.jlibraw.OutputColorSpace;
import net.jalbum.jlibraw.RAWImageReadParam;
import net.jalbum.jlibraw.WBPresets;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.JMenuButton;
import se.datadosen.component.JMultilingualComboBox;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JWideSpinner;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.annotations.Bound;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

@Bound(value="rawParam")
public class JRawSettingsPanel
extends JPanel
implements EditListener,
JComponentHolder {
    private AlbumObject ao;
    private boolean showing = false;
    PluginContext context;
    RAWImageReadParam model = new RAWImageReadParam();
    @Text(value="raw.whiteBalance")
    JLabel whiteBalanceLabel = new JLabel();
    JComboBox<WBPresets> whiteBalance = new JMultilingualComboBox(WBPresets.values());
    JCheckBox exposureCorrect = new JCheckBox();
    @Text(value="raw.exposureCorrection")
    JLabel exposureCorrectionLabel = new JLabel();
    JSpinner exposureShift = new JWideSpinner(new SpinnerNumberModel(0.0, -3.0, 2.0, 0.3333333333333333){

        @Override
        public Object getPreviousValue() {
            double nv = (Double)this.getValue() - 0.3333333333333333;
            nv = (double)Math.round(nv * 3.0) / 3.0;
            if (this.getMinimum().compareTo(nv) <= 0) {
                return nv;
            }
            return this.getValue();
        }

        @Override
        public Object getNextValue() {
            double nv = (Double)this.getValue() + 0.3333333333333333;
            nv = (double)Math.round(nv * 3.0) / 3.0;
            if (this.getMaximum().compareTo(nv) >= 0) {
                return nv;
            }
            return this.getValue();
        }
    }, 24);
    @Text(value="raw.exposureShiftUnit")
    JLabel exposureShiftUnit = new JLabel();
    @Text(value="raw.exposurePreserveHighlights")
    JLabel exposurePreserveHighlightsLabel = new JLabel();
    JSpinner exposurePreserveHighlights = new JWideSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1));
    @Text(value="raw.brightness")
    JLabel brightnessLabel = new JLabel();
    JSpinner brightness = new JSpinner(new SpinnerNumberModel(1.0, 0.01, 10.0, 0.1));
    @Text(value="raw.gamma")
    JLabel gammaLabel = new JLabel();
    JComboBox gamma = new JMultilingualComboBox(Gamma.values());
    @Text(value="raw.outputColorSpace")
    JLabel outputColorSpaceLabel = new JLabel();
    JComboBox outputColorSpace = new JMultilingualComboBox(OutputColorSpace.values());
    @ToolTipText(value="raw.changesMade")
    JDot changedIndicator = new JDot(Color.red.darker());
    @Text(value="ui.setAsDefault")
    Action setAsDefaultAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BeanBinder.setProperties((Object)JRawSettingsPanel.this.model, JRawSettingsPanel.this);
            JRawSettingsPanel.this.context.getJAlbumContext().getEngine().setRawParam((RAWImageReadParam)JRawSettingsPanel.this.model.clone());
            JRawSettingsPanel.this.updateChangesIndicator();
            JRawSettingsPanel.this.context.getRootFolder().getDescendants().forEach(ao -> ((AlbumObjectImpl)ao).updateRepresentingIcon());
        }
    };
    @Text(value="ui.useDefaultSettings")
    Action useDefaultSettings = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlbumObjectProperties props = JRawSettingsPanel.this.ao.getProperties();
            props.remove("imageReadParam");
            props.save(false);
            JRawSettingsPanel.this.setAlbumObject(JRawSettingsPanel.this.ao);
            JRawSettingsPanel.this.context.getEditPanel().reload();
        }
    };
    @Text(value="ui.useInitialSettings")
    Action useInitialSettings = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlbumObjectProperties props = JRawSettingsPanel.this.ao.getProperties();
            RAWImageReadParam initial = new RAWImageReadParam();
            RAWImageReadParam def = JRawSettingsPanel.this.context.getJAlbumContext().getEngine().getRawParam();
            if (initial.equals((Object)def)) {
                props.remove("imageReadParam");
            } else {
                props.put("imageReadParam", initial);
            }
            props.save(false);
            JRawSettingsPanel.this.setAlbumObject(JRawSettingsPanel.this.ao);
            JRawSettingsPanel.this.context.getEditPanel().reload();
        }
    };
    @Text(value="ui.setAsDefault")
    @ToolTipText(value="raw.setAsDefaultToolTip")
    JButton setAsDefaultButton = new JButton(this.setAsDefaultAction);
    @Text(value="ui.reset")
    JMenuButton resetButton = new JMenuButton();
    JProgressSpinner spinner;

    public JRawSettingsPanel(PluginContext context) {
        this.context = context;
        this.init();
    }

    private boolean isRawImage(AlbumObject ao) {
        try {
            return ao.getFile().exists() && ao.getCategory() == Category.image && ao.getImageInfo().isRaw();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setAlbumObject(AlbumObject ao) {
        this.ao = ao;
        if (ao == null || !this.isRawImage(ao) && this.showing) {
            this.context.getEditPanel().removeCustomTab(this);
            this.showing = false;
            return;
        }
        if (this.isRawImage(ao) && !this.showing) {
            this.context.getEditPanel().addCustomTab(Msg.get("edit.rawTitle"), this);
            this.showing = true;
        }
        this.model = ao.getProperties().get("imageReadParam", (RAWImageReadParam)this.context.getJAlbumContext().getEngine().getRawParam().clone());
        BeanBinder.getProperties((Object)this.model, this);
        this.updateChangesIndicator();
    }

    private void init() {
        this.context.getEditPanel().addEditListener(this);
        Msg.maintainTranslated(this);
        this.setOpaque(true);
        this.setBackground(JAlbumColor.text);
        this.putClientProperty("expanded", Boolean.TRUE);
        this.putClientProperty("priority", "high");
        this.setLayout(new RiverLayout(4, 2));
        this.resetButton.addActions(this.useDefaultSettings, this.useInitialSettings);
        this.spinner = new JProgressSpinner(this.context.getEditPanel().imageLoadingProperty());
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.exposureCorrect, this.exposureShift, this.exposureShiftUnit);
        this.add(this.whiteBalanceLabel);
        this.add("br left", this.whiteBalance);
        this.add(this.changedIndicator);
        this.add(this.spinner);
        this.add("p", this.exposureCorrectionLabel);
        this.add("br", this.exposureCorrect);
        this.add(this.exposureShift);
        this.add(this.exposureShiftUnit);
        this.add("p", this.exposurePreserveHighlightsLabel);
        this.add("br", this.exposurePreserveHighlights);
        this.add("p", this.gammaLabel);
        this.add("br", this.gamma);
        this.add("p", this.brightnessLabel);
        this.add("br", this.brightness);
        this.add("p", this.outputColorSpaceLabel);
        this.add("br", this.outputColorSpace);
        this.add("p", Box.createVerticalStrut(12));
        this.add("p", this.setAsDefaultButton);
        this.add(this.resetButton);
        new StateMonitor(){

            @Override
            public void onChange() {
                if (!BeanBinder.isSynchingUI()) {
                    BeanBinder.setProperties((Object)JRawSettingsPanel.this.model, JRawSettingsPanel.this);
                    AlbumObjectProperties props = JRawSettingsPanel.this.ao.getProperties();
                    props.put("imageReadParam", JRawSettingsPanel.this.model);
                    props.save(false);
                    JRawSettingsPanel.this.context.getJAlbumContext().getExplorer().setRAWSettingsClipboard(JRawSettingsPanel.this.model);
                    JRawSettingsPanel.this.context.getEditPanel().reload();
                    JRawSettingsPanel.this.updateChangesIndicator();
                }
            }
        }.add(this.whiteBalance).add(this.exposureCorrect).add(this.exposureShift).add(this.exposurePreserveHighlights).add(this.brightness).add(this.gamma).add(this.outputColorSpace);
    }

    private void updateChangesIndicator() {
        RAWImageReadParam def = this.context.getJAlbumContext().getEngine().getRawParam();
        this.changedIndicator.setVisible(!this.model.equals((Object)def));
    }

    private static class JDot
    extends JLabel {
        private Color color = Color.black;
        private int size = 14;

        public JDot() {
        }

        public JDot(Color color) {
            this.color = color;
        }

        @Override
        public Dimension getPreferredSize() {
            Insets in = this.getInsets();
            return new Dimension(this.size + in.left + in.right, this.size + in.top + in.bottom);
        }

        @Override
        protected void paintComponent(Graphics g2d) {
            super.paintComponent(g2d);
            Graphics2D g = (Graphics2D)g2d;
            if (!this.isEnabled()) {
                g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int cw = this.getWidth();
            int ch = this.getHeight();
            Insets in = this.getInsets();
            int width = cw - in.left - in.right;
            int height = ch - in.top - in.bottom;
            g.setColor(this.color);
            g.fillOval(in.left, in.top, width, height);
        }
    }
}

