/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.WritableImage;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.jalbum.projectgroups.JProjectGroupsComboBox;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.RetinaIcon;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.SmartFlowLayout;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.KeyNavigator;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.TypeNavigator;
import se.datadosen.util.BlockingLifoQueue;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.WindowUtilities;

public class JProjectsPanel
extends JPanel {
    public static final int ITEM_GAP = 10;
    public static final double BROWSER_SCALE = 3.2;
    public static final int BROWSER_WIDTH = 1024;
    public static final int BROWSER_HEIGHT = 768;
    public static final int THUMB_WIDTH = 320;
    public static final int THUMB_HEIGHT = 240;
    public static final String PREVIEW_FILE_NAME = "preview.jpg";
    static final Dimension BROWSER_SIZE = new Dimension(1024, 768);
    static Dimension THUMB_SIZE = new Dimension(320, 240);
    ProjectGroup projectGroup = ProjectGroup.RECENT_PROJECTS_GROUP;
    ThreadPoolExecutor previewPool = JProjectsPanel.createPreviewExecutorPool();
    private JProjectObject selectedObject;
    private ArrayList<ActionListener> listeners = new ArrayList();
    private KeyNavigator<JProjectObject> keyNavigator = new KeyNavigator(this);
    private TypeNavigator typeNavigator = new TypeNavigator(this){

        @Override
        public String getFocusedName() {
            return JProjectsPanel.this.selectedObject != null ? JProjectsPanel.this.selectedObject.getName() : "";
        }

        @Override
        public void focusNextMatching(String prefix) {
            JProjectObject next = JProjectsPanel.this.keyNavigator.nextMatching(JProjectsPanel.this.selectedObject, prefix);
            if (next != null) {
                JProjectsPanel.this.selectObject(next);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    };
    Comparator<JProjectObject> byName = (c1, c2) -> c1.project.getName().compareToIgnoreCase(c2.project.getName());
    LambdaAction previewAction = new LambdaAction(Msg.get("ui.preview"), () -> {
        try {
            File indexFile;
            File file = indexFile = this.selectedObject != null ? this.selectedObject.project.getIndexFile() : null;
            if (indexFile != null && indexFile.exists()) {
                JAlbumContext.getInstance().getFrame().openInBrowser(indexFile.toURI().toURL(), null);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    });
    LambdaAction reloadAction = new LambdaAction(Msg.get("ui.reload"), () -> {
        AlbumObject root = this.selectedObject.project.getRootFolder();
        File jAlbumDir = new File(root.getFile(), ".jalbum");
        File previewFile = new File(jAlbumDir, PREVIEW_FILE_NAME);
        previewFile.delete();
        this.selectedObject.thumb.setIcon(null);
        this.selectedObject.thumbLoader = null;
        this.selectedObject.repaint();
    });
    private static JSmartDialog theDialog;
    private static JProjectsPanel projectsPanel;
    private static JComboBox<Config.ProjectOrdering> projectOrdering;
    private static final DateFormat dateFormat;

    private static ThreadPoolExecutor createPreviewExecutorPool() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(6, 6, 5L, TimeUnit.SECONDS, new BlockingLifoQueue<Runnable>(), r -> new WebPreviewThread(r));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public JProjectsPanel() {
        this.setFocusable(true);
        this.setLayout(new SmartFlowLayout(3, 10, 10));
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L) {
                if (this.isShowing()) {
                    this.requestFocusInWindow();
                    if (this.selectedObject != null) {
                        this.selectObject(this.selectedObject);
                    }
                } else {
                    this.previewPool.shutdownNow();
                }
            }
        });
    }

    public void setProjectGroup(ProjectGroup group) {
        JProjectObject sel;
        this.projectGroup = group;
        this.removeAll();
        if (group instanceof JProjectGroupsComboBox.SelectFolderProjectGroup && !((JProjectGroupsComboBox.SelectFolderProjectGroup)group).chooseLocation()) {
            return;
        }
        for (AlbumProject ap : group.getProjects()) {
            try {
                this.add(new JProjectObject(ap));
            }
            catch (IOException ex) {
                Logger.getLogger(JProjectsPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.orderBy((Config.ProjectOrdering)projectOrdering.getSelectedItem());
        this.validate();
        this.repaint();
        if (this.selectedObject != null && (sel = this.getProject(this.selectedObject.project.getProjectFile())) != null) {
            this.selectObject(sel);
            return;
        }
        this.scrollRectToVisible(new Rectangle(10, 10));
    }

    private List<JProjectObject> getObjects() {
        ArrayList<JProjectObject> list = new ArrayList<JProjectObject>();
        for (Component c : this.getComponents()) {
            list.add((JProjectObject)c);
        }
        return list;
    }

    private void setObjects(List<JProjectObject> list) {
        this.removeAll();
        for (JProjectObject p : list) {
            this.add(p);
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorder(Comparator<JProjectObject> comparator) {
        Object object = this.getTreeLock();
        synchronized (object) {
            List<JProjectObject> objects = this.getObjects();
            Collections.sort(objects, comparator);
            this.setObjects(objects);
        }
    }

    private void orderBy(Config.ProjectOrdering ordering) {
        this.reorder((a, b) -> this.projectGroup.getComparator(ordering).compare(a.project, b.project));
    }

    private void go(KeyNavigator.Direction direction) {
        JProjectObject dest = this.keyNavigator.getNeigbour(this.selectedObject, direction);
        if (dest != null) {
            this.selectObject(dest);
        }
    }

    public File getSelectedFile() {
        return this.selectedObject != null ? this.selectedObject.project.getProjectFile() : null;
    }

    public void setSelectedFile(File selectedFile) {
        this.selectObject(this.getProject(selectedFile));
    }

    private JProjectObject getProject(File f) {
        for (Component comp : this.getComponents()) {
            JProjectObject po = (JProjectObject)comp;
            if (!po.project.getProjectFile().equals(f)) continue;
            return po;
        }
        return null;
    }

    private void selectObject(JProjectObject object) {
        File oldSelectedFile = null;
        File newSelectedFile = null;
        if (this.selectedObject != null) {
            oldSelectedFile = this.selectedObject.project.getProjectFile();
            this.selectedObject.setSelected(false);
        }
        this.selectedObject = object;
        if (this.selectedObject != null) {
            newSelectedFile = this.selectedObject.project.getProjectFile();
            this.selectedObject.setSelected(true);
            this.scrollRectToVisible(this.selectedObject.getBounds());
            this.selectedObject.requestFocusInWindow();
        }
        this.firePropertyChange("selectedFile", oldSelectedFile, newSelectedFile);
    }

    private boolean isProjectDir(File f) {
        File projectFile = new File(f, "jalbum-settings.jap");
        return f.isDirectory() && projectFile.exists();
    }

    public void addActionListener(ActionListener listener) {
        ArrayList<ActionListener> newList = new ArrayList<ActionListener>(this.listeners);
        newList.add(listener);
        this.listeners = newList;
    }

    public void removeActionListener(ActionListener listener) {
        ArrayList<ActionListener> newList = new ArrayList<ActionListener>(this.listeners);
        newList.remove(listener);
        this.listeners = newList;
    }

    protected void fireActionPerformed(int modifiers) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 0, "fileChosen", modifiers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateTree(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] children;
            for (Component child : children = container.getComponents()) {
                if (child instanceof Container) {
                    JProjectsPanel.invalidateTree((Container)child);
                    continue;
                }
                if (!child.isValid()) continue;
                child.invalidate();
            }
            if (container.isValid()) {
                container.invalidate();
            }
        }
    }

    public static void showDialog(JAlbumFrame window) {
        Tracer.getInstance().trace("open project gallery");
        if (theDialog == null) {
            projectsPanel = new JProjectsPanel();
            theDialog = new JSmartDialog((Frame)window, Msg.get("ui.projectGallery")){

                @Override
                public void setVisible(boolean visible) {
                    WindowUtilities.stickyBounds(this, visible);
                    super.setVisible(visible);
                }
            };
            theDialog.registerActions(new LambdaAction(ae -> {
                theDialog.setVisible(false);
                File selectedFile = projectsPanel.getSelectedFile();
                if (selectedFile != null) {
                    window.loadProject(projectsPanel.getSelectedFile());
                }
            }), new LambdaAction(ae -> theDialog.setVisible(false)));
            projectsPanel.addActionListener(ae -> {
                if ((ae.getModifiers() & 0x240) == 0) {
                    theDialog.setVisible(false);
                }
                window.loadProject(projectsPanel.getSelectedFile());
            });
            JScrollPane scroller = new JScrollPane(projectsPanel, 20, 31);
            scroller.getVerticalScrollBar().setUnitIncrement(Config.getConfig().getExplorerScrollSpeed());
            InputMap im = scroller.getInputMap(0);
            im.put(KeyStroke.getKeyStroke(38, 64), "unitScrollUp");
            im.put(KeyStroke.getKeyStroke(40, 64), "unitScrollDown");
            im.put(KeyStroke.getKeyStroke(37, 64), "unitScrollLeft");
            im.put(KeyStroke.getKeyStroke(39, 64), "unitScrollRight");
            ActionMap am = scroller.getActionMap();
            am.put("unitScrollUp", new LambdaAction(ae -> projectsPanel.go(KeyNavigator.Direction.NORTH)));
            am.put("unitScrollDown", new LambdaAction(ae -> projectsPanel.go(KeyNavigator.Direction.SOUTH)));
            am.put("unitScrollLeft", new LambdaAction(ae -> projectsPanel.go(KeyNavigator.Direction.WEST)));
            am.put("unitScrollRight", new LambdaAction(ae -> projectsPanel.go(KeyNavigator.Direction.EAST)));
            JPanel content = new JPanel(new BorderLayout());
            JPanel top = new JPanel(new RiverLayout());
            top.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            top.add(new JLabel(Msg.get("ui.location")));
            JProjectGroupsComboBox projectGroupsSelector = new JProjectGroupsComboBox();
            projectGroupsSelector.addActionListener(ae -> SwingUtilities.invokeLater(() -> projectsPanel.setProjectGroup(projectGroupsSelector.getSelectedGroup())));
            projectGroupsSelector.setSelectedItem(ProjectGroups.getInstance().getCurrentGroup());
            top.add(projectGroupsSelector);
            top.add(new JLabel(Msg.get("edit.orderBy")));
            projectOrdering.addActionListener(ae -> projectsPanel.orderBy((Config.ProjectOrdering)projectOrdering.getSelectedItem()));
            top.add(projectOrdering);
            content.add((Component)top, "North");
            content.add((Component)scroller, "Center");
            theDialog.getContentPane().add(content);
            theDialog.setPreferredSize(new Dimension(1040, 740));
            theDialog.pack();
        }
        if (JProjectsPanel.projectsPanel.previewPool.isShutdown()) {
            JProjectsPanel.projectsPanel.previewPool = JProjectsPanel.createPreviewExecutorPool();
        }
        projectsPanel.setSelectedFile(window.projectChooser.getSelectedFile());
        theDialog.setVisible(true);
    }

    static {
        projectOrdering = new JComboBox<Config.ProjectOrdering>(Config.ProjectOrdering.values());
        dateFormat = DateFormat.getDateInstance();
    }

    class JProjectObject
    extends JComponent {
        private boolean reloading;
        private ImageIcon tmpIcon;
        private Future thumbLoader;
        JLabel thumb = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (JProjectObject.this.thumbLoader == null && (JProjectObject.this.thumb.getIcon() == null || JProjectObject.this.thumb.getIcon() == JProjectObject.this.tmpIcon)) {
                    this.loadProjectPreview();
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return THUMB_SIZE;
            }

            private void setThumbImage(BufferedImage read) {
                GraphicsConfiguration gc = this.getGraphicsConfiguration();
                if (gc != null) {
                    BufferedImage bi = gc.createCompatibleImage(640, 480);
                    Graphics2D g = bi.createGraphics();
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.drawImage(read, 0, 0, JProjectObject.this.thumb.getWidth() * 2, JProjectObject.this.thumb.getHeight() * 2, null);
                    g.dispose();
                    JProjectObject.this.thumb.setIcon(new RetinaIcon(bi));
                    JProjectObject.this.tmpIcon = null;
                }
            }

            private void loadProjectPreview() {
                try {
                    AlbumObject rep;
                    AlbumObject root = JProjectObject.this.project.getRootFolder();
                    File indexFile = JProjectObject.this.project.getIndexFile();
                    File jAlbumDir = new File(root.getFile(), ".jalbum");
                    File previewFile = new File(jAlbumDir, JProjectsPanel.PREVIEW_FILE_NAME);
                    AlbumObjectProperties props = root.getProperties();
                    long lastMadeDate = props.get("lastMadeDate", 0L);
                    if (previewFile.exists()) {
                        this.setThumbImage(ImageIO.read(previewFile));
                        if (previewFile.lastModified() > lastMadeDate) {
                            return;
                        }
                    } else if (JProjectObject.this.thumb.getIcon() == null && (rep = root.getRepresentingAlbumObject(true)) != null) {
                        JProjectObject.this.tmpIcon = rep.getRepresentingIcon(THUMB_SIZE, true);
                        JProjectObject.this.thumb.setIcon(JProjectObject.this.tmpIcon);
                    }
                    JProjectObject.this.thumbLoader = JProjectsPanel.this.previewPool.submit(() -> {
                        if (indexFile != null && indexFile.exists()) {
                            WebPreviewThread previewThread = (WebPreviewThread)Thread.currentThread();
                            CountDownLatch latch = new CountDownLatch(1);
                            previewThread.setOnPageLoaded(() -> {
                                if (!JProjectObject.this.reloading) {
                                    JProjectObject.this.reloading = true;
                                    previewThread.browser.getEngine().reload();
                                    return;
                                }
                                JProjectObject.this.reloading = false;
                                Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)800.0), ae -> {
                                    try {
                                        WritableImage wi = previewThread.browser.snapshot(null, null);
                                        BufferedImage read = SwingFXUtils.fromFXImage((javafx.scene.image.Image)wi, null);
                                        try {
                                            jAlbumDir.mkdir();
                                            ImageIO.write(this.toGBR(read), "jpeg", previewFile);
                                        }
                                        catch (IOException ex) {
                                            Logger.getLogger(JProjectObject.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                        this.setThumbImage(read);
                                    }
                                    finally {
                                        latch.countDown();
                                    }
                                }, new KeyValue[0])});
                                timeline.play();
                            });
                            Platform.runLater(() -> {
                                try {
                                    if (!previewThread.stage.isShowing()) {
                                        previewThread.stage.show();
                                        previewThread.stage.toBack();
                                    }
                                    previewThread.browser.getEngine().load(indexFile.toURI().toURL().toExternalForm());
                                }
                                catch (MalformedURLException ex) {
                                    Logger.getLogger(JProjectsPanel.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            try {
                                latch.await();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }

            private RenderedImage toGBR(BufferedImage read) {
                BufferedImage bgr = new BufferedImage(read.getWidth(), read.getHeight(), 5);
                Graphics2D g = bgr.createGraphics();
                g.drawImage((Image)read, 0, 0, null);
                g.dispose();
                return bgr;
            }
        };
        JLabel nameLabel = new JLabel();
        private boolean selected = false;
        private AlbumProject project;

        public File getProjectFile() {
            return this.project.getProjectFile();
        }

        public JProjectObject(File projectFile) throws IOException {
            this(new AlbumProject(projectFile));
        }

        public JProjectObject(AlbumProject ap) throws IOException {
            this.project = ap;
            this.setLayout(new BorderLayout());
            this.setSelected(false);
            this.setFocusable(false);
            this.nameLabel.setText(this.project.getName() + " - " + dateFormat.format(new Date(this.project.getLastModified())));
            this.setToolTipText(this.project.getLongName());
            this.add((Component)this.thumb, "Center");
            JPanel labelPanel = new JPanel(new FlowLayout());
            labelPanel.add(this.nameLabel);
            this.add((Component)labelPanel, "South");
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ JProjectObject this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.handlePopup(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.this$1.JProjectsPanel.this.selectObject(this.this$1);
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        this.this$1.JProjectsPanel.this.fireActionPerformed(e.getModifiersEx());
                    }
                    this.this$1.getParent().requestFocusInWindow();
                    this.handlePopup(e);
                }

                private boolean handlePopup(MouseEvent e) {
                    boolean isTrigger = e.isPopupTrigger();
                    if (isTrigger) {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(new LambdaAction(Msg.get("edit.open"), ae -> this.this$1.JProjectsPanel.this.fireActionPerformed(e.getModifiersEx())));
                        try {
                            File indexFile = this.this$1.JProjectsPanel.this.selectedObject != null ? this.this$1.JProjectsPanel.this.selectedObject.project.getIndexFile() : null;
                            this.this$1.JProjectsPanel.this.previewAction.setEnabled(indexFile != null && indexFile.exists());
                        }
                        catch (IOException ex) {
                            this.this$1.JProjectsPanel.this.previewAction.setEnabled(false);
                        }
                        popup.add(this.this$1.JProjectsPanel.this.previewAction);
                        popup.add(this.this$1.JProjectsPanel.this.reloadAction);
                        popup.setLocation(e.getPoint());
                        popup.show((Component)e.getSource(), e.getPoint().x, e.getPoint().y);
                    }
                    return isTrigger;
                }
            });
        }

        @Override
        public String getName() {
            return Normalizer.normalize(this.project.getName(), Normalizer.Form.NFC);
        }

        private void setSelected(boolean b) {
            this.selected = b;
            this.setBorder(this.selected ? JAlbumBorders.createSelectedImageBorder() : JAlbumBorders.createImageBorder());
        }

        public boolean isSelected() {
            return this.selected;
        }
    }

    private static class WebPreviewThread
    extends Thread {
        WebView browser;
        Runnable onPageLoaded;
        Runnable init = () -> {
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater(() -> {
                this.stage = new Stage();
                this.stage.setTitle("Preview");
                this.browser = new WebView();
                Scene scene = new Scene((Parent)this.browser, 1024.0, 768.0);
                this.stage.setScene(scene);
                this.stage.show();
                this.stage.toBack();
                this.browser.getEngine().getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
                    if (newValue == Worker.State.FAILED) {
                        throw new RuntimeException("Browser error. Restarting thread");
                    }
                    if (this.browser.getEngine().getLocation().equals("about:blank")) {
                        if (newValue == Worker.State.SUCCEEDED) {
                            latch.countDown();
                        }
                    } else if (newValue == Worker.State.SUCCEEDED && this.onPageLoaded != null) {
                        this.onPageLoaded.run();
                    }
                });
                this.browser.getEngine().load("about:blank");
            });
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(JProjectsPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        };
        Stage stage;

        public Runnable getOnPageLoaded() {
            return this.onPageLoaded;
        }

        public void setOnPageLoaded(Runnable onPageLoaded) {
            this.onPageLoaded = onPageLoaded;
        }

        public WebPreviewThread(Runnable target) {
            super(target, "Web Preview Renderer");
        }

        @Override
        public void run() {
            if (this.init != null) {
                this.init.run();
                this.init = null;
            }
            try {
                super.run();
            }
            finally {
                this.cleanup();
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.cleanup();
        }

        private void cleanup() {
            Platform.runLater(() -> {
                this.stage.close();
                this.browser.getEngine().load(null);
            });
        }
    }
}

