/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JPlainToggleButton;
import se.datadosen.component.JRolloverButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.MacUtilities;
import se.datadosen.jalbum.MakeAlbumTask;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TaskbarProgress;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Platform;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;

public class JProgressDialog
extends JDialog
implements AlbumBeanListener {
    private JPanel thePanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JLabel directory = new JLabel();
    private JProgressBar progressBar = new JProgressBar(){

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 280;
            return dim;
        }
    };
    @Text(value="ui.openFolder")
    @Icon(value="20x20/open-folder.svg")
    Action openFolderAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Tracer.getInstance().trace("open album folder clicked");
                BrowserLauncher.openLocal(JProgressDialog.this.getFrame().engine.getOutputDir());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    private JPlainToggleButton pauseButton = new JPlainToggleButton(Icons.small("pause"), Icons.small("pause-1"));
    private JButton abortButton = new JPlainButton(Icons.small("abort"), Icons.small("abort-1"));
    private JButton runInBackgroundButton = new JPlainButton(Icons.small("background-process"), Icons.small("background-process-1"));
    private JButton viewAlbumButton = new JRolloverButton();
    private JButton publishButton;
    private JButton openFolderButton = new JRolloverButton(this.openFolderAction);
    private JLabel file = new JLabel();
    private JLabel timeInfo = new JLabel();
    private Stopwatch timer = new Stopwatch();
    boolean abort = false;
    private boolean finished = false;
    private Window parent;
    private Object engineMonitor = new Object();

    public JProgressDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.init();
    }

    public JProgressDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.init();
    }

    public JProgressDialog(Dialog parent, String title, boolean modal, boolean abortOnly) {
        super(parent, title, modal);
        this.parent = parent;
        try {
            this.initComponents(abortOnly);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void init() {
        try {
            this.initComponents(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents(boolean abortOnly) throws Exception {
        Msg.maintainTranslated(this);
        this.thePanel.setLayout(new BorderLayout());
        this.publishButton = new JRolloverButton(this.getFrame().actions.publishAction);
        if (!abortOnly) {
            this.viewAlbumButton.setAction(this.getFrame().actions.viewAlbumAction);
            this.publishButton.addActionListener(actionEvent -> {
                if (this.finished) {
                    this.dispose();
                }
            });
            this.getRootPane().setDefaultButton(this.viewAlbumButton);
            this.pauseButton.setSelectedIcon(Icons.small("play"));
            this.pauseButton.setRolloverSelectedIcon(Icons.small("play-1"));
            this.pauseButton.setToolTipText(Msg.get("progress.pause"));
            this.pauseButton.setSelectedToolTipText(Msg.get("ui.continue"));
            this.pauseButton.addActionListener(this::pauseButton_actionPerformed);
        }
        this.abortButton.addActionListener(this::abortPerformed);
        this.abortButton.setToolTipText(Msg.get("abort"));
        this.runInBackgroundButton.addActionListener(this::runInBackground);
        this.runInBackgroundButton.setToolTipText(Msg.get("ui.runInBackground"));
        this.runInBackgroundButton.setVisible(false);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.mainPanel.setLayout(new RiverLayout());
        this.directory.setText(Msg.get("progress.processingInfo"));
        this.file.setText(Msg.get("progress.fileInfo"));
        this.timeInfo.setText(Msg.get("progress.estimatedTimeLeftInfo"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JProgressDialog.this.this_windowClosing(e);
            }
        });
        this.getContentPane().add(this.thePanel);
        this.thePanel.add((Component)this.mainPanel, "Center");
        this.mainPanel.add(this.directory);
        this.mainPanel.add("br", this.file);
        this.mainPanel.add("br", Box.createRigidArea(new Dimension(4, 4)));
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.add((Component)this.progressBar, "Center");
        JPanel progressControls = new JPanel(new FlowLayout(0, 0, 0));
        progressControls.add(Box.createRigidArea(new Dimension(4, 4)));
        if (!abortOnly) {
            progressControls.add(this.pauseButton);
        }
        progressControls.add(this.runInBackgroundButton);
        progressControls.add(this.abortButton);
        progressPanel.add((Component)progressControls, "East");
        this.mainPanel.add("br hfill", progressPanel);
        this.mainPanel.add("br", Box.createRigidArea(new Dimension(4, 4)));
        this.mainPanel.add("br", this.timeInfo);
        this.thePanel.add((Component)this.buttonPanel, "South");
        if (!abortOnly) {
            this.buttonPanel.add(this.viewAlbumButton);
            this.buttonPanel.add(this.openFolderButton);
            this.buttonPanel.add(this.publishButton);
        }
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        AbstractAction closeAction = new AbstractAction("close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JProgressDialog.this.abortPerformed(null);
            }
        };
        pane.registerKeyboardAction(closeAction, "close", ks, 2);
        pane.registerKeyboardAction(this.getFrame().actions.showConsoleWindowAction, "showConsole", KeyStroke.getKeyStroke(118, 0), 2);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private static String twoDigits(int x) {
        if (x < 10) {
            return "0" + x;
        }
        return "" + x;
    }

    private static String timerFormat(int secs) {
        int hours = secs / 3600;
        int minutes = secs % 3600 / 60;
        int seconds = secs % 60;
        return hours + ":" + JProgressDialog.twoDigits(minutes) + ":" + JProgressDialog.twoDigits(seconds);
    }

    @Override
    public void status(String message) {
        if (!this.isVisible()) {
            SwingUtilities.invokeLater(() -> this.updateStateAndSetVisible(true, message));
        } else {
            this.directory.setText(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageProcessingStarted(AlbumBeanEvent e) {
        if (this.finished) {
            return;
        }
        Object object = this.engineMonitor;
        synchronized (object) {
            if (this.pauseButton.isSelected()) {
                try {
                    this.engineMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isVisible() && !this.abort) {
                    SwingUtilities.invokeLater(() -> this.updateStateAndSetVisible(true));
                }
            }
        }
        if (this.abort) {
            e.abortProcessing();
        }
        SwingUtilities.invokeLater(() -> {
            if (!this.timer.isRunning()) {
                this.timer.start();
                this.directory.setText(Msg.get("progress.processingInfo"));
                this.directory.setVisible(true);
                this.file.setText(e.msg);
                this.file.setVisible(true);
                if (!this.progressBar.isIndeterminate()) {
                    int processedFiles = e.getProcessedFiles();
                    int totalFiles = e.getTotalFiles();
                    this.progressBar.setMaximum(totalFiles);
                    this.progressBar.setValue(processedFiles);
                    if (totalFiles > 0) {
                        TaskbarProgress.setProgress(this, 100 * processedFiles / totalFiles);
                    }
                    this.progressBar.setString(Msg.get("progress.processingInfo2", e.getProcessingCount(), totalFiles));
                    this.progressBar.setStringPainted(true);
                }
            }
            this.directory.setText(Msg.get("progress.processingInfo") + " " + e.directory);
            this.file.setText(e.msg);
        });
    }

    @Override
    public void imageProcessingFinished(AlbumBeanEvent e) {
        this.updateProgress(e, 0.0f);
    }

    private void updateProgress(AlbumBeanEvent e, float currentObjectProgress) {
        if (this.finished) {
            return;
        }
        if (this.abort) {
            e.abortProcessing();
        }
        SwingUtilities.invokeLater(() -> {
            this.file.setText(e.msg);
            int processedFiles = e.getProcessedFiles();
            int totalFiles = e.getTotalFiles();
            int vProcessed = processedFiles * 100 + (int)(currentObjectProgress * 100.0f);
            int vTotal = 100 * totalFiles;
            if (!this.progressBar.isIndeterminate()) {
                this.progressBar.setMaximum(vTotal);
                this.progressBar.setValue(vProcessed);
                this.progressBar.setString(Msg.get("progress.processingInfo2", e.getProcessingCount(), totalFiles));
                if (totalFiles > 0) {
                    TaskbarProgress.setProgress(this, 100 * vProcessed / vTotal);
                }
            }
            long elapsed = this.timer.getMillis();
            if (vProcessed > 0) {
                long totalMillis = (long)vTotal * elapsed / (long)vProcessed;
                int secsLeft = (int)(totalMillis - elapsed) / 1000;
                this.timeInfo.setText(Msg.get("progress.estimatedTimeLeftInfo") + " " + JProgressDialog.timerFormat(secsLeft));
            }
        });
    }

    @Override
    public void videoProcessingProgress(AlbumBeanEvent e, float progress) {
        this.updateProgress(e, progress);
    }

    @Override
    public boolean requestConfirmation(String message, Function<Component, Boolean> showDialog) {
        return showDialog.apply(this);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            TaskbarProgress.setProgress(this, 0);
        }
        super.setVisible(visible);
    }

    void setDialogToFinishedState() {
        JProgressDialog theDialog = this;
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(this.progressBar.getMaximum());
        TaskbarProgress.setProgress(this, 0);
        this.pauseButton.setEnabled(false);
        this.runInBackgroundButton.setEnabled(false);
        this.viewAlbumButton.setAction(this.getFrame().actions.viewAlbumAction);
        this.publishButton.setEnabled(true);
        this.openFolderButton.setEnabled(true);
        this.directory.setText(" ");
        this.file.setText(Msg.get("ui.albumGenerationDone"));
        this.timer.stop();
        long secsElapsed = this.timer.getMillis() / 1000L;
        this.timeInfo.setText(Msg.get("progress.timeElapsedInfo") + " " + JProgressDialog.timerFormat((int)secsElapsed));
        if (Config.getConfig().getPreviewMode() != Config.PreviewMode.external) {
            this.setVisible(false);
            this.dispose();
            if (!this.getFrame().albumExplorer.isPreviewTabShowing()) {
                this.getFrame().actions.viewAlbumAction.actionPerformed(new ActionEvent(this, 1001, ""));
            } else {
                this.getFrame().albumExplorer.browserPanel.reload();
            }
            this.getFrame().statusBar.setText(this.timeInfo.getText());
            TipOfTheDay.showInBackground(Msg.get("tip.previewMode"), 30);
            return;
        }
        if (Platform.isMac()) {
            MacUtilities.requestUserAttention(false);
        } else if (Platform.isWindows()) {
            theDialog.toFront();
            theDialog.requestFocusInWindow();
        }
    }

    private void runInBackground(ActionEvent e) {
        JAlbumFrame window = (JAlbumFrame)this.parent;
        AlbumBean engine = window.getEngine();
        engine.removeAllAlbumBeanListeners();
        engine.globalVariables.put("window", (Object)null);
        window.setupNewEngine();
        window.ui2Engine();
        MakeAlbumTask makeTask = new MakeAlbumTask(engine, window);
        window.multiMaker.makeInBackground(makeTask, false);
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortPerformed(ActionEvent e) {
        Object object = this.engineMonitor;
        synchronized (object) {
            this.abort = true;
            this.updateStateAndSetVisible(false);
            if (!this.finished) {
                this.pauseButton.setSelected(false);
                this.engineMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void pauseButton_actionPerformed(ActionEvent e) {
        Object object = this.engineMonitor;
        synchronized (object) {
            if (this.pauseButton.isSelected()) {
                this.timer.stop();
            } else {
                this.timer.start();
                this.engineMonitor.notifyAll();
            }
        }
    }

    public void setIndeterminate(boolean b) {
        this.progressBar.setIndeterminate(b);
    }

    private JAlbumFrame getFrame() {
        return JAlbumContext.getInstance().getFrame();
    }

    public void updateStateAndSetVisible(boolean visible) {
        this.updateStateAndSetVisible(visible, " ");
    }

    private void updateStateAndSetVisible(boolean visible, String message) {
        if (visible) {
            this.pauseButton.setSelected(false);
            this.pauseButton.setEnabled(true);
            this.runInBackgroundButton.setEnabled(true);
            this.publishButton.setEnabled(false);
            this.openFolderButton.setEnabled(false);
            this.directory.setText(message);
            this.file.setText(" ");
            this.timeInfo.setText(" ");
            this.progressBar.setValue(0);
            this.progressBar.setString("");
            this.timer.reset();
            this.abort = false;
            this.finished = false;
            this.abortButton.setToolTipText(Msg.get("close"));
            this.buttonPanel.invalidate();
            this.pack();
            this.setLocationRelativeTo(this.parent);
            if (!this.isVisible()) {
                this.setVisible(visible);
            }
        } else {
            this.setVisible(visible);
        }
    }

    void this_windowClosing(WindowEvent e) {
        if (!this.finished) {
            this.abort = true;
        }
    }
}

